/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;

public abstract class NcArray2D
extends NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MAX_ELEMENTS = 18000000;
    private static final int CHUNK_ELEMENTS = 15000000;
    protected NcAxis xAxis_;
    protected NcAxis yAxis_;
    protected int xDimNum_ = -1;
    protected int yDimNum_ = -1;
    protected int aveDimIndex_ = -1;
    private int numCols_ = -1;
    private int numRows_ = -1;
    private int numAves_ = -1;
    private int maxRows_;
    private int maxRowsOver8_;
    private int maxAveSlices_;
    private int rowOffset_;
    private int sectionRows_;
    private double[][] averages_;

    public NcArray2D(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    protected void setAveDimIndex(int index) {
        if (index < 0) {
            return;
        }
        this.aveDimIndex_ = index;
        this.setSliceIndex(this.aveDimIndex_, -1);
    }

    protected void measureAxes() {
        if (this.xDimNum_ < 0) {
            throw new NcException("X-dimension index is not set.");
        }
        if (this.yDimNum_ < 0) {
            throw new NcException("Y-dimension index is not set.");
        }
        this.numCols_ = this.shape_[this.xDimNum_];
        this.numRows_ = this.shape_[this.yDimNum_];
        long total = (long)this.numCols_ * (long)this.numRows_;
        if (total < 18000000L) {
            this.maxRows_ = this.numRows_;
        } else {
            this.maxRows_ = 18000000 / this.numCols_;
            if (this.maxRows_ > this.numRows_) {
                this.maxRows_ = this.numRows_;
            } else if (this.maxRows_ > 200) {
                this.maxRows_ = this.maxRows_ / 200 * 200;
            } else if (this.maxRows_ > 160) {
                this.maxRows_ = this.maxRows_ / 160 * 160;
            } else if (this.maxRows_ > 1280) {
                this.maxRows_ = this.maxRows_ / 120 * 120;
            } else if (this.maxRows_ > 64) {
                this.maxRows_ = this.maxRows_ / 64 * 64;
            }
        }
        this.maxRowsOver8_ = this.maxRows_ / 8;
        this.maxRowsOver8_ -= this.maxRowsOver8_ % 16;
        if (this.maxRows_ == this.numRows_ && this.aveDimIndex_ > -1) {
            this.numAves_ = this.shape_[this.aveDimIndex_];
            this.maxAveSlices_ = 15000000 / (this.maxRows_ * this.numCols_);
            this.maxAveSlices_ = Math.max(this.maxAveSlices_, 1);
            this.maxAveSlices_ = Math.min(this.maxAveSlices_, this.numAves_);
        }
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.xDimNum_ || i == this.yDimNum_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public int getColumnCount() {
        return this.numCols_;
    }

    public int getRowCount() {
        return this.numRows_;
    }

    public NcAxis getXAxis() {
        return this.xAxis_;
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    public int getXDimensionIndex() {
        return this.xDimNum_;
    }

    public int getYDimensionIndex() {
        return this.yDimNum_;
    }

    @Override
    public boolean isAveragingDimension(int dimIndex) {
        return dimIndex == this.aveDimIndex_;
    }

    public double valueAt(int col, int row) {
        if (row < 0 || row >= this.numRows_) {
            throw new IndexOutOfBoundsException("Row index " + row + " outside range: " + this.numRows_);
        }
        if (col < 0 || col >= this.numCols_) {
            throw new IndexOutOfBoundsException("Col index " + col + " outside range: " + this.numCols_);
        }
        if (this.aveDimIndex_ > -1 && this.sIndex_[this.aveDimIndex_] == -1) {
            return this.dimensionAverageAt(col, row);
        }
        if (this.needsSlice_ || this.slice_ == null || row < this.rowOffset_ || row >= this.rowOffset_ + this.maxRows_) {
            this.doSlice(row);
        }
        try {
            int offRow = row - this.rowOffset_;
            return this.getDoubleFromSlice(col, offRow, -1);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed -  row,col = {}.{}", (Object)row, (Object)col);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    public double dimensionAverageAt(int col, int row) throws NcException {
        if (this.aveDimIndex_ == -1) {
            throw new NcException("Dimension averaging not set up for this array.");
        }
        if (this.averages_ == null || row < this.rowOffset_ - 1 || row >= this.rowOffset_ + this.maxRows_) {
            this.doAverage(row);
        }
        return this.averages_[row - this.rowOffset_][col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSlice(int row) throws NcException {
        NcArray2D ncArray2D = this;
        synchronized (ncArray2D) {
            double aaa = (double)row / (double)this.maxRows_;
            this.rowOffset_ = (double)Math.round(aaa) > Math.floor(aaa) ? this.maxRows_ * (row / this.maxRows_) + (int)(0.5 * (double)this.maxRows_) : this.maxRows_ * (row / this.maxRows_);
            if (this.rowOffset_ > row - this.maxRowsOver8_) {
                this.rowOffset_ = Math.max(row - this.maxRowsOver8_, 0);
            }
            this.sectionRows_ = this.rowOffset_ + this.maxRows_ > this.numRows_ ? this.numRows_ - this.rowOffset_ : this.maxRows_;
            int[] sOrigin = new int[this.rank_];
            int[] sShape = new int[this.rank_];
            try {
                this.needsSlice_ = true;
                for (int i = 0; i < this.rank_; ++i) {
                    sOrigin[i] = this.sIndex_[i];
                    sShape[i] = 1;
                }
                sOrigin[this.xDimNum_] = 0;
                sOrigin[this.yDimNum_] = this.rowOffset_;
                sShape[this.xDimNum_] = this.numCols_;
                sShape[this.yDimNum_] = this.sectionRows_;
                this.slice_ = this.njvarDS_.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                this.needsSlice_ = false;
            }
            catch (InvalidRangeException exc) {
                throw new ArrayIndexOutOfBoundsException("Index out of range.");
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException("Do Slice - " + exc.toString());
            }
        }
    }

    private double getDoubleFromSlice(int col, int row, int ave) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.xDimNum_] = col;
        ss[this.yDimNum_] = row;
        if (ave > -1) {
            ss[this.aveDimIndex_] = ave;
        }
        this.sliceIdx_.set(ss);
        return NcArrayUtils.getDoubleFromSlice(this.slice_, this.sliceIdx_, this.hasScaleOffset_, this.isUnsigned_);
    }

    private final void doAverage(int row) throws NcException {
        if (this.aveDimIndex_ < 0) {
            throw new NcException("Array has no averaging dimension.");
        }
        this.slice_ = null;
        if (this.averages_ == null) {
            this.averages_ = new double[this.maxRows_][this.numCols_];
        }
        this.rowOffset_ = this.maxRows_ * (row / this.maxRows_);
        if (this.rowOffset_ > row - 2) {
            this.rowOffset_ = Math.max(row - 2, 0);
        }
        this.sectionRows_ = this.rowOffset_ + this.maxRows_ > this.numRows_ ? this.numRows_ - this.rowOffset_ : this.maxRows_;
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        int[][] aveCount = new int[this.sectionRows_][this.numCols_];
        for (int k = 0; k < this.sectionRows_; ++k) {
            for (int j = 0; j < this.numCols_; ++j) {
                this.averages_[k][j] = 0.0;
                aveCount[k][j] = 0;
            }
        }
        int xsize = this.xAxis_.getLength();
        try {
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.xDimNum_] = 0;
            sOrigin[this.yDimNum_] = this.numRows_ - this.rowOffset_ - this.sectionRows_;
            sShape[this.xDimNum_] = this.numCols_;
            sShape[this.yDimNum_] = this.sectionRows_;
            for (int iave = 0; iave < this.numAves_; iave += this.maxAveSlices_) {
                int aveSlices = iave + this.maxAveSlices_ >= this.numAves_ ? this.numAves_ - iave : this.maxAveSlices_;
                sOrigin[this.aveDimIndex_] = iave;
                sShape[this.aveDimIndex_] = aveSlices;
                this.slice_ = this.njvarDS_.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                for (int mm = 0; mm < aveSlices; ++mm) {
                    for (int k = 0; k < this.sectionRows_; ++k) {
                        for (int j = 0; j < xsize; ++j) {
                            double dval = this.getDoubleFromSlice(j, k, mm);
                            if (this.isMissingOrInvalid(dval)) continue;
                            double[] dArray = this.averages_[k];
                            int n = j;
                            dArray[n] = dArray[n] + dval;
                            int[] nArray = aveCount[k];
                            int n2 = j;
                            nArray[n2] = nArray[n2] + 1;
                        }
                    }
                }
                this.slice_ = null;
            }
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Do Average: " + exc.toString());
        }
        for (int k = 0; k < this.sectionRows_; ++k) {
            for (int j = 0; j < xsize; ++j) {
                if (aveCount[k][j] == 0) {
                    this.averages_[k][j] = Double.NaN;
                    continue;
                }
                if (aveCount[k][j] <= 1) continue;
                double[] dArray = this.averages_[k];
                int n = j;
                dArray[n] = dArray[n] / (double)aveCount[k][j];
            }
        }
        this.needsSlice_ = false;
    }

    public double rowAverageOf(int row) throws NcException {
        double result = 0.0;
        int count = 0;
        for (int i = 0; i < this.numCols_; ++i) {
            double value = this.valueAt(i, row);
            if (Double.isNaN(value)) continue;
            result += value;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return result;
        }
        return result /= (double)count;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum == this.xDimNum_ || dimNum == this.yDimNum_) {
            throw new NcException("Plot axis is not an independent dimension");
        }
        if (dimNum != this.aveDimIndex_ || index == -1) {
            this.averages_ = null;
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    protected void findExtrema() {
        double[] range;
        if (this.rank_ < 3 && (range = this.getActualRange()) != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.numRows_; ++j) {
            for (int i = 0; i < this.numCols_; ++i) {
                double value = this.valueAt(i, j);
                if (this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    LOGGER.trace("min {}", (Object)this.minimum_);
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
                LOGGER.trace("max {}", (Object)this.maximum_);
            }
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    public int[] getEnclosingCell(double colval, double rowval) {
        int incol = this.getXAxis().findNearestIndex(colval);
        int inrow = this.getYAxis().findNearestIndex(rowval);
        if (incol < 0 || inrow < 0) {
            return null;
        }
        return new int[]{incol, inrow};
    }
}

