/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public interface NcArrayLonLatAuxiliary {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcAxis getXAxis();

    public NcAxis getYAxis();

    public boolean hasBadValues();

    public double valueAt(int var1, int var2);

    public double[][] getCellCornerLonLats(int var1, int var2);

    public double longitudeAt(int var1, int var2);

    public double latitudeAt(int var1, int var2);

    public boolean doCellsShareCorner(int var1, int var2, int var3, int var4);

    public boolean doCellsAbut(int var1, int var2, int var3, int var4);

    public static VariableDS[] getCoordinateVars(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS, int reqRank) {
        VariableDS[] varsCS = NcArrayLonLatAuxiliary.getCoordinateVarsCS(ncd, varDS, reqRank);
        VariableDS[] varsNoCS = NcArrayLonLatAuxiliary.getCoordinateVarsNoCS(ncd, ncg, varDS, reqRank);
        if (varsCS == null && varsNoCS == null) {
            LOGGER.trace("No lon-lat vars found");
            return null;
        }
        if (varsCS == null) {
            LOGGER.trace("Lon-lat vars found in attribute but not in CS.");
            return varsNoCS;
        }
        if (varsNoCS == null) {
            LOGGER.trace("Lon-lat vars found in CS but not in attribute.");
            return varsCS;
        }
        if (varsNoCS[0].equals(varsCS[0]) && varsNoCS[1].equals(varsCS[1])) {
            LOGGER.trace("Lon-lat vars in attribute equal those in CS.");
            return varsCS;
        }
        LOGGER.trace("Lon-lat vars in attribute do NOT match those in CS.");
        LOGGER.trace("Returning those from attribute.");
        return varsNoCS;
    }

    public static VariableDS[] getCoordinateVarsCS(NcDataset ncd, VariableDS varDS, int reqRank) {
        List<CoordinateSystem> csList = varDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            LOGGER.trace("No coordinate system in list");
            return null;
        }
        CoordinateSystem cs = csList.get(0);
        if (cs == null) {
            return null;
        }
        LOGGER.trace("Found a coordinate system to work with");
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        LOGGER.trace("CS reports lonax {}, latax {}", (Object)(lonax != null ? 1 : 0), (Object)(latax != null ? 1 : 0));
        if (lonax == null || latax == null) {
            return null;
        }
        LOGGER.trace("lonax {}, latax {}", (Object)lonax.getShortName(), (Object)latax.getShortName());
        if (NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, lonax, latax, reqRank)) {
            return new VariableDS[]{lonax, latax};
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsNoCS(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS, int reqRank) {
        LOGGER.trace("");
        String[] tokens = NcVarUtils.parseCoordinatesAttribute(varDS);
        LOGGER.trace("has tokens {}", (Object)(tokens != null ? 1 : 0));
        if (tokens == null || tokens.length == 0) {
            VariableDS[] vars;
            if (ncd.isHdfeos() && (vars = NcArrayLonLatAuxiliary.getCoordinateVarsHdfeos(ncd, varDS, reqRank)) != null) {
                return vars;
            }
            return NcArrayLonLatAuxiliary.getCoordinateVarsNoTokens(ncd, ncg, varDS, reqRank);
        }
        VariableDS[] vars = NcArrayLonLatAuxiliary.getCoordinateVarsAtPath(ncd, varDS, tokens);
        if (vars != null && NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
            return vars;
        }
        vars = null;
        Group grp = varDS.getParentGroup();
        vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, grp, tokens);
        if (vars != null && NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
            return vars;
        }
        vars = null;
        Group pgrp = grp.getParentGroup();
        if (pgrp == null) {
            return null;
        }
        vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, pgrp, tokens);
        if (vars != null && NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
            return vars;
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsHdfeos(NcDataset ncd, VariableDS varDS, int reqRank) {
        String altgrpPath;
        LOGGER.trace("");
        String[] tokens = new String[]{"Longitude", "Latitude"};
        Group grp = varDS.getParentGroup();
        String grpPath = grp.getFullName();
        VariableDS[] vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, grp, tokens);
        if (vars != null && NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
            return vars;
        }
        vars = null;
        Group pgrp = grp.getParentGroup();
        if (pgrp == null) {
            return null;
        }
        vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, pgrp, tokens);
        if (vars != null && NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
            return vars;
        }
        vars = null;
        if (grpPath.endsWith("Data_Fields") && (vars = NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, altgrpPath = grpPath.replace("Data_Fields", "Geolocation_Fields"), tokens)) != null && NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, vars[0], vars[1], reqRank)) {
            return vars;
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsNoTokens(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS, int reqRank) {
        LOGGER.trace("");
        if (ncg == null) {
            LOGGER.trace("Not in data grouping?");
            return null;
        }
        NcVariable[] cvars = ncg.getCoordinateVars();
        if (cvars == null) {
            LOGGER.trace("No cvars reported in group");
            return null;
        }
        if (cvars.length < 2) {
            LOGGER.trace("Group cvars array is too small");
            return null;
        }
        ArrayList<VariableDS> lonvars = new ArrayList<VariableDS>(10);
        ArrayList<VariableDS> latvars = new ArrayList<VariableDS>(10);
        for (NcVariable ncvar : cvars) {
            int[] shape;
            VariableDS njvar;
            NcCoordinateVarType cvarType = ncvar.getCoordinateVarType();
            if (cvarType == NcCoordinateVarType.LONGITUDE) {
                njvar = ncvar.getNjVariable();
                if (njvar.getRank() != reqRank) continue;
                shape = njvar.getShape();
                lonvars.add(njvar);
                continue;
            }
            if (cvarType != NcCoordinateVarType.LATITUDE || (njvar = ncvar.getNjVariable()).getRank() != reqRank) continue;
            shape = njvar.getShape();
            latvars.add(njvar);
        }
        if (lonvars.size() < 1 || latvars.size() < 1) {
            return null;
        }
        LOGGER.trace("Found {} lonvars, {} latvars", (Object)lonvars.size(), (Object)latvars.size());
        for (VariableDS lonvar : lonvars) {
            for (VariableDS latvar : latvars) {
                if (!NcArrayLonLatAuxiliary.validateCoordinateVars(ncd, varDS, lonvar, latvar, reqRank)) continue;
                LOGGER.trace("got a match!");
                return new VariableDS[]{lonvar, latvar};
            }
        }
        return null;
    }

    public static VariableDS[] getCoordinateVarsAtPath(NcDataset ncd, VariableDS varDS, String ... paths) {
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        for (String token : paths) {
            VariableDS tokenVar = ncd.getNjVariable(token);
            if (tokenVar == null) continue;
            String lcname = tokenVar.getShortName().toLowerCase();
            String unitsStr = NcVarUtils.getUnitsString(tokenVar);
            if ("longitude".equals(lcname) || NcUnitUtils.isDegreesEast(unitsStr)) {
                lonVarDS = tokenVar;
                continue;
            }
            if (!"latitude".equals(lcname) && !NcUnitUtils.isDegreesNorth(unitsStr)) continue;
            latVarDS = tokenVar;
        }
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS};
    }

    public static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, VariableDS varDS, String ... tokens) {
        Group grp = varDS.getParentGroup();
        String grpPath = grp.getFullName();
        return NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, grpPath, tokens);
    }

    public static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, VariableDS varDS, Group njgrp, String ... tokens) {
        if (njgrp == null) {
            return null;
        }
        String grpPath = njgrp.getFullName();
        return NcArrayLonLatAuxiliary.getCoordinateVarsInGroup(ncd, varDS, grpPath, tokens);
    }

    public static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, VariableDS varDS, String grpPath, String ... tokens) {
        if (tokens[0].lastIndexOf(47) >= 0) {
            return null;
        }
        String[] tokens2 = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens2[i] = grpPath.length() > 0 ? grpPath + "/" + tokens[i] : tokens[i];
        }
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        for (String token : tokens2) {
            VariableDS tokenVar = ncd.getNjVariable(token);
            if (tokenVar == null) continue;
            String lcname = tokenVar.getShortName().toLowerCase();
            String unitsStr = NcVarUtils.getUnitsString(tokenVar);
            if ("longitude".equals(lcname) || NcUnitUtils.isDegreesEast(unitsStr)) {
                lonVarDS = tokenVar;
                continue;
            }
            if ("latitude".equals(lcname) || NcUnitUtils.isDegreesNorth(unitsStr)) {
                latVarDS = tokenVar;
                continue;
            }
            LOGGER.trace("-- Found var '{}' but it appears to be neither lon or lat", (Object)token);
        }
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS};
    }

    public static boolean validateCoordinateVars(NcDataset ncd, VariableDS varDS, VariableDS lonvar, VariableDS latvar, int reqRank) {
        Objects.requireNonNull(lonvar, "lon CV cannot be null");
        Objects.requireNonNull(latvar, "lat CV cannot be null");
        if (reqRank < 2 || reqRank > 3) {
            throw new IllegalArgumentException("Not a rank we understand");
        }
        if (varDS == null || lonvar == null || latvar == null) {
            return false;
        }
        int varRank = varDS.getRank();
        if (varRank < reqRank) {
            return false;
        }
        if (lonvar.getRank() != reqRank || latvar.getRank() != reqRank) {
            return false;
        }
        int[] lonshape = lonvar.getShape();
        int[] latshape = latvar.getShape();
        for (int i = 0; i < reqRank; ++i) {
            Dimension dd2;
            if (lonshape[i] != latshape[i]) {
                return false;
            }
            Dimension dd1 = lonvar.getDimension(i);
            if (!dd1.equals(dd2 = latvar.getDimension(i))) {
                return false;
            }
            int didx = NcVarUtils.findDimensionIndex(varDS, dd1);
            if (didx >= 0) continue;
            return false;
        }
        if (reqRank == 2) {
            return lonshape[0] >= 2 && lonshape[1] >= 2;
        }
        int[] gridVarIndices = NcArrayLonLatAuxiliary.getGridVarDimIndices3D(ncd, lonvar);
        if (gridVarIndices == null) {
            return false;
        }
        int xdim = gridVarIndices[0];
        int ydim = gridVarIndices[1];
        return lonshape[xdim] >= 2 && lonshape[ydim] >= 2;
    }

    public static int[] getGridVarDimIndices3D(NcDataset ncd, VariableDS gridvar) {
        if (gridvar.getRank() != 3) {
            throw new IllegalArgumentException("gridvar is not 3d");
        }
        int xDimIdx = -1;
        int yDimIdx = -1;
        int oDimIdx = -1;
        for (int i = 0; i < 3; ++i) {
            Attribute longA;
            Dimension dd = gridvar.getDimension(i);
            String dname = dd.getShortName();
            String lcname = dname.toLowerCase();
            if (lcname.equalsIgnoreCase("band") || lcname.equalsIgnoreCase("channel") || lcname.equalsIgnoreCase("fov") || lcname.equalsIgnoreCase("sensor") || lcname.equalsIgnoreCase("time") || lcname.equalsIgnoreCase("nbin")) {
                oDimIdx = i;
                LOGGER.trace("* Found oDimIdx {}", (Object)oDimIdx);
                continue;
            }
            VariableDS cv = ncd.getNjCoordinateVariable(dd);
            if (cv != null && (longA = cv.findAttribute("long_name")) != null) {
                String longName = longA.getStringValue().toLowerCase();
                if (longName.indexOf("x-coordinate") > -1 || longName.indexOf("across-track") > -1 || longName.matches(".*across.swath.*") || longName.matches(".*across.track.*")) {
                    xDimIdx = i;
                    LOGGER.trace("* Found xdim via long_name {}", (Object)i);
                    continue;
                }
                if (longName.indexOf("y-coordinate") > -1 || longName.indexOf("along-track") > -1 || longName.matches(".*along.swath.*") || longName.matches(".*along.track.*")) {
                    yDimIdx = i;
                    LOGGER.trace("* Found ydim via long_name {}", (Object)i);
                    continue;
                }
            }
            if (xDimIdx < 0 || yDimIdx < 0) {
                if (lcname.contains("xdim") || lcname.contains("xtrack") || lcname.contains("btrack") || lcname.contains("numcells") || lcname.contains("azsize")) {
                    LOGGER.trace("* Found xdim via dim name {}, {}", (Object)i, (Object)lcname);
                    xDimIdx = i;
                    continue;
                }
                if (lcname.contains("ydim") || lcname.contains("ytrack") || lcname.contains("atrack") || lcname.contains("track") || lcname.contains("numrows") || lcname.contains("rasize")) {
                    LOGGER.trace("* Found ydim via dim name {}, {}", (Object)i, (Object)lcname);
                    yDimIdx = i;
                    continue;
                }
            }
            LOGGER.trace("* Dim {} {} matches no obvious name or attr", (Object)i, (Object)dname);
        }
        if (oDimIdx < 0 && (xDimIdx < 0 || yDimIdx < 0)) {
            LOGGER.trace("no DimIdxs found; looking for shortest dim");
            oDimIdx = 0;
            if (gridvar.getDimension(1).getLength() < gridvar.getDimension(0).getLength()) {
                oDimIdx = 1;
            }
            if (gridvar.getDimension(2).getLength() < gridvar.getDimension(1).getLength()) {
                oDimIdx = 2;
            }
        }
        LOGGER.trace("* After scan : x {}, y {}, b {}", xDimIdx, yDimIdx, oDimIdx);
        if (xDimIdx > -1 && yDimIdx > -1) {
            oDimIdx = 3 - xDimIdx - yDimIdx;
        } else if (oDimIdx > -1) {
            if (oDimIdx == 0) {
                xDimIdx = 2;
                yDimIdx = 1;
            } else if (oDimIdx == 1) {
                xDimIdx = 2;
                yDimIdx = 0;
            } else {
                xDimIdx = 1;
                yDimIdx = 0;
            }
        } else {
            return null;
        }
        LOGGER.trace("* Finally! x {}, y {}, b {}", xDimIdx, yDimIdx, oDimIdx);
        return new int[]{xDimIdx, yDimIdx, oDimIdx};
    }
}

