/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.UtmProjection;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcArrayLonLatUTM
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ProjectionImpl njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;

    public NcArrayLonLatUTM(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.UTM);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.UTM)) {
            throw new NcException("Variable is not projected type UTM.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = vds.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null || pj instanceof LatLonProjection) {
            pj = this.buildProjectionImpl();
        }
        if (pj == null) {
            throw new NcException("Null projection impl.");
        }
        if (!(pj instanceof UtmProjection)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of UTM");
        }
        this.njProj_ = pj;
        CoordinateAxis xaxis = this.getNjCoordinateAxis(NcAxisType.GEOX);
        String xUnits = xaxis.getUnitsString();
        try {
            Unit projUnit = NcUnitUtils.parse("km");
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ProjectionImpl buildProjectionImpl() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("universal_transverse_mercator")) {
            throw new NcException("Grid mapping name is not UTM.");
        }
        Attribute zoneA = this.mappingVarDS_.findAttribute("utm_zone_number");
        if (zoneA == null) {
            throw new NcException("UTM zone attribute is missing.");
        }
        int zone = zoneA.getNumericValue().intValue();
        boolean isNorth = true;
        if (zone < 0) {
            zone = Math.abs(zone);
            isNorth = false;
        }
        UtmProjection upj = null;
        Attribute semiA = this.mappingVarDS_.findAttribute("semi_major_axis");
        Attribute invfA = this.mappingVarDS_.findAttribute("inverse_flattening");
        if (semiA == null && invfA == null) {
            upj = new UtmProjection(zone, isNorth);
        } else if (semiA == null || invfA == null) {
            LOGGER.warn("Axis or flattening attribute found, but not the other.");
            upj = new UtmProjection(zone, isNorth);
        } else {
            double semi = semiA.getNumericValue().doubleValue();
            double invf = invfA.getNumericValue().doubleValue();
            if (semi < 10000.0) {
                semi *= 1000.0;
            }
            upj = new UtmProjection(semi, invf, zone, isNorth);
        }
        return upj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        Point2D.Double xy = NcArrayLonLatUTM.transformNjLL2XY(this.njProj_, lon, lat);
        if (xy == null) {
            return null;
        }
        if (this.fromProjUnits_ != null) {
            xy.x = this.fromProjUnits_.convert(xy.x);
            xy.y = this.fromProjUnits_.convert(xy.y);
        }
        return xy;
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = this.toProjUnits_ == null ? x : this.toProjUnits_.convert(x);
        double yy = this.toProjUnits_ == null ? y : this.toProjUnits_.convert(y);
        return NcArrayLonLatUTM.transformNjXY2LL(this.njProj_, xx, yy);
    }
}

