/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorTableFactory;
import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceListEntry;
import gov.nasa.giss.util.ResourceList;
import gov.nasa.giss.util.ResourceListEntry;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorTableResourceList
extends ResourceList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String RESOURCE_DESC = "color table";
    private static final String RESOURCE_DESC_PLURAL = "color tables";
    private static final String RESOURCES_DIR = "resources";
    private static final String APP_SUPPORT_DIR = "colorbars";

    public ColorTableResourceList() {
        super(new ColorTableFilenameFilter());
        this.scanJarDirectory(ColorTableResourceList.class, RESOURCES_DIR);
        this.scanAppSupportDirectory(APP_SUPPORT_DIR);
    }

    @Override
    public String getResourceDescription() {
        return RESOURCE_DESC;
    }

    @Override
    public String getResourceDescriptionPlural() {
        return RESOURCE_DESC_PLURAL;
    }

    @Override
    public String getAppSupportDirectoryName() {
        return APP_SUPPORT_DIR;
    }

    @Override
    protected Object createObject(File f) {
        try {
            return ColorTableFactory.open(f);
        }
        catch (Exception exc) {
            if (LOGGER.isDebugEnabled()) {
                exc.printStackTrace();
            }
            throw new RuntimeException(exc.toString());
        }
    }

    @Override
    protected ResourceListEntry createSetEntry(ResourceListEntry.LocType loctype, Object link, Object o) {
        if (o != null && !(o instanceof AbstractColorTable)) {
            throw new IllegalArgumentException("Object is not a " + this.getResourceDescription());
        }
        return new ColorTableResourceListEntry(loctype, link, o);
    }
}

