/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.overlay.OutlineSegment;
import java.util.ArrayList;

public class OutlineArea {
    private final ArrayList<OutlineSegment> segments_ = new ArrayList(200);
    private double[] bounds_ = new double[]{-180.0, 90.0, 180.0, -90.0};

    public LonLatBounds getBounds() {
        return new LonLatBounds(this.bounds_[0], this.bounds_[1], this.bounds_[2], this.bounds_[3]);
    }

    public void setBounds(double left, double top, double right, double bottom) {
        this.bounds_ = new double[]{left, top, right, bottom};
    }

    public void setBounds(LonLatBounds bb) {
        this.setBounds(bb.getWest(), bb.getNorth(), bb.getEast(), bb.getSouth());
    }

    public void setBounds(double[] bb) {
        if (bb.length != 4) {
            throw new IllegalArgumentException("Bounds array should have 4 items.");
        }
        this.setBounds(bb[0], bb[1], bb[2], bb[3]);
    }

    public void addSegment(OutlineSegment segment) {
        this.segments_.add(segment);
    }

    public int size() {
        return this.segments_.size();
    }

    public OutlineSegment getSegment(int index) {
        return this.segments_.get(index);
    }
}

