/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.PointPoleProjection;
import gov.nasa.giss.math.Hyperbolic;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class AugustEpicycloidal
extends PointPoleProjection {
    public static final String PROJECTION_NAME = "August Epicycloidal";
    public static final int PROPERTIES = 4096;
    private static final double LOBE_DX = 1.885618016720417;
    private static final double LOBE_DY = 1.4142135623730951;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 1.4142135623730951;

    public AugustEpicycloidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public AugustEpicycloidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public AugustEpicycloidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 2.0, 1.4142135623730951);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double lambdaRadOver2 = 0.5 * lambdaRad;
        double phiRad = Math.toRadians(lat);
        double phiRadOver2 = 0.5 * phiRad;
        if (Math.abs(lambdaRadOver2) < 1.0E-5 && Math.abs(phiRadOver2) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(phiRadOver2) < 1.0E-5) {
            double xp = Math.sin(lambdaRadOver2) / (1.0 + Math.cos(lambdaRadOver2));
            x = 0.5 * xp * (3.0 + xp * xp);
            y = 0.0;
        } else if (Math.abs(lambdaRadOver2) < 1.0E-5) {
            double tanHalfPhi = Math.tan(phiRadOver2);
            double xtanHalfPhi = Math.sqrt(1.0 - tanHalfPhi * tanHalfPhi);
            double yp = tanHalfPhi / (1.0 + xtanHalfPhi);
            x = 0.0;
            y = 0.5 * yp * (3.0 - yp * yp);
        } else {
            double tanHalfPhi = Math.tan(phiRadOver2);
            double xtanHalfPhi = Math.sqrt(1.0 - tanHalfPhi * tanHalfPhi);
            double denom = 1.0 + Math.cos(lambdaRadOver2) * xtanHalfPhi;
            double xp = Math.sin(lambdaRadOver2) * xtanHalfPhi / denom;
            double yp = tanHalfPhi / denom;
            double xp2 = xp * xp;
            double yp2 = yp * yp;
            x = 0.5 * xp * (3.0 + xp2 - 3.0 * yp2);
            y = 0.5 * yp * (3.0 + 3.0 * xp2 - yp2);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double capY;
        double capY2;
        double capX2;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        if (y == 0.0) {
            if (Math.abs(xOverRS) > Math.PI) {
                return null;
            }
            return new PointLL(this.lambdaC_ + xOverRS, 0.0);
        }
        if (x == 0.0) {
            if (Math.abs(yOverRS) > 1.5707963267948966) {
                return null;
            }
            return new PointLL(this.lambdaC_, yOverRS);
        }
        double v = Math.abs(yOverRS);
        double v2 = v * v;
        double u = Math.abs(xOverRS);
        double u2 = u * u;
        double onePlusU2PlusV2 = 1.0 + u2 + v2;
        double sinSq3Eta = 0.5 * (onePlusU2PlusV2 - Math.sqrt(onePlusU2PlusV2 * onePlusU2PlusV2 - 4.0 * v2));
        double sin3Eta = Math.sqrt(sinSq3Eta);
        double etaRad = Math.asin(sin3Eta) / 3.0;
        double cosh3Xi = v / sin3Eta;
        double xiRad = Hyperbolic.arcosh(cosh3Xi) / 3.0;
        double capX = 2.0 * Math.sinh(xiRad) * Math.cos(etaRad);
        double lambdaRad = 2.0 * Math.atan2(2.0 * capX, 1.0 - (capX2 = capX * capX) - (capY2 = (capY = 2.0 * Math.cosh(xiRad) * Math.sin(etaRad)) * capY));
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phiRad = 2.0 * Math.atan2(2.0 * capY, 1.0 + capX2 + capY2);
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AugustEpicycloidal augustEpicycloidal = this;
        synchronized (augustEpicycloidal) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double v = y * this.invRS_;
                double v2 = v * v;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double u = x * this.invRS_;
                    double u2 = u * u;
                    double onePlusU2PlusV2 = 1.0 + u2 + v2;
                    double sinSq3Eta = 0.5 * (onePlusU2PlusV2 - Math.sqrt(onePlusU2PlusV2 * onePlusU2PlusV2 - 4.0 * v2));
                    double sin3Eta = Math.sqrt(sinSq3Eta);
                    double etaRad = Math.asin(sin3Eta) / 3.0;
                    double cosh3Xi = v / sin3Eta;
                    double xiRad = Math.log(cosh3Xi + Math.sqrt(cosh3Xi * cosh3Xi - 1.0)) / 3.0;
                    double capX = 2.0 * Math.sinh(xiRad) * Math.cos(etaRad);
                    double capY = 2.0 * Math.cosh(xiRad) * Math.sin(etaRad);
                    double capX2 = capX * capX;
                    double capY2 = capY * capY;
                    double lambdaRad = 2.0 * Math.atan2(2.0 * capX, 1.0 - capX2 - capY2);
                    double phiRad = 2.0 * Math.atan2(2.0 * capY, 1.0 + capX2 + capY2);
                    if (lambdaRad > Math.PI && u > 1.885618016720417) continue block3;
                    if (lambdaRad > Math.PI) continue;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }
}

