/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;

public class Cassini
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Cassini";
    public static final int PROPERTIES = 0x200000;
    private static final double WIDTH_FACTOR = 1.5707963267948966;
    private static final double HEIGHT_FACTOR = Math.PI;
    private static final double DEFAULT_HEIGHT = 45.0;
    private double height_ = 45.0;
    private double heightRad_ = 0.7853981633974483;
    private ProjDoubleParameter hghtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center of map", "Height", "\u00b0", 45.0, 0.002, 360.0, true, true);

    public Cassini(int width, int height) {
        this(width, height, 0, 0);
    }

    public Cassini(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Cassini(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200000, width, height, xmargin, ymargin, 1.5707963267948966, Math.PI);
        this.addParameter(this.hghtParam_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.hghtParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setHeight(this.hghtParam_.getValue());
    }

    public void setHeight(double height) {
        this.height_ = height;
        this.heightRad_ = Math.toRadians(height);
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double halfHRad = 0.5 * this.heightRad_;
        Insets ins = this.getInsets();
        double uw = (double)this.outWidth_ - 2.0 * (double)ins.left;
        double uh = (double)this.outHeight_ - 2.0 * (double)ins.top;
        double www = Math.min(1.5707963267948966, halfHRad * uw / uh);
        this.setSizeFactors(www, halfHRad);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double latRad = Math.toRadians(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double b = Math.cos(latRad) * Math.sin(lambdaRad);
        double x = Math.asin(b);
        double y = Math.atan2(Math.tan(latRad), Math.cos(lambdaRad)) - this.phiCRad_;
        if (y > Math.PI) {
            y -= Math.PI * 2;
        } else if (y < -Math.PI) {
            y += Math.PI * 2;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double d = y * this.invRS_ + this.phiCRad_;
        double xOverRS = x * this.invRS_;
        double phiRad = Math.asin(Math.sin(d) * Math.cos(xOverRS));
        double lambdaRad = Math.atan2(Math.tan(xOverRS), Math.cos(d));
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Cassini cassini = this;
        synchronized (cassini) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double d = y * this.invRS_ + this.phiCRad_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double phiRad = Math.asin(Math.sin(d) * Math.cos(xOverRS));
                    double lambdaRad = Math.atan2(Math.tan(xOverRS), Math.cos(d));
                    this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }

    @Override
    public LonLatBounds getBounds() {
        double llTop = Math.min(this.phiC_ + 0.5 * this.height_, 90.0);
        double llBottom = Math.max(this.phiC_ - 0.5 * this.height_, -90.0);
        if (llTop > 89.0 || llBottom < -89.0) {
            return new LonLatBounds(-180.0, llTop, 180.0, llBottom);
        }
        return LonLatBounds.ENTIRE_GLOBE;
    }
}

