/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClarkeTwilight
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Clarke Twilight";
    public static final int PROPERTIES = 0x200040;
    private static final double CONST_D = 1.4;
    private static final double EDGE_RADIUS = 108.0;
    private static final double EDGE_RADIUS_RAD = Math.toRadians(108.0);
    private static final double COS_EDGE = Math.cos(EDGE_RADIUS_RAD);
    private static final double SIN_EDGE = Math.sin(EDGE_RADIUS_RAD);
    private static final double RADIUS_FACTOR = 1.4 * SIN_EDGE / (1.4 + COS_EDGE);

    public ClarkeTwilight(int width, int height) {
        this(width, height, 0, 0);
    }

    public ClarkeTwilight(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ClarkeTwilight(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, RADIUS_FACTOR, RADIUS_FACTOR);
        this.radiusDeg_ = 108.0;
        super.setFillCorners(false);
        this.autoscale();
    }

    @Override
    public void setEdgeRadius(double r) {
        LOGGER.debug("Radius param not pertinent to this projection");
    }

    @Override
    public void setFillCorners(boolean fill) {
        LOGGER.debug("Fill param not pertinent to this projection");
    }

    @Override
    protected final void finishScaling() {
        LOGGER.debug("");
        this.rhoBorder_ = RADIUS_FACTOR * this.rS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < COS_EDGE) {
            return -1.0;
        }
        return 1.4 / (1.4 + cosZ);
    }

    @Override
    protected final double getZForRhoRS(double rhoRS) {
        double rho = rhoRS * this.invRS_;
        double dOverRho = 1.4 / rho;
        double z = rho;
        for (int iter = 0; iter < 33; ++iter) {
            double sinZ = Math.sin(z);
            double cosZ = Math.cos(z);
            double func = 1.4 + cosZ - dOverRho * sinZ;
            double dfunc = -sinZ - dOverRho * cosZ;
            double dz = -func / dfunc;
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

