/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Eckert3
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Eckert III";
    private static final double CONST_A = 2.0 / Math.sqrt(22.43597501544853);
    private static final double INV_A = 1.0 / CONST_A;
    private static final double WIDTH_FACTOR = 2.0 * CONST_A * Math.PI;
    private static final double HEIGHT_FACTOR = CONST_A * Math.PI;

    public Eckert3(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Eckert3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        if (dot0 == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
        double hw = dot0.x - dotN.x;
        double h = dotS.y - dotN.y;
        if (hw == 0.0) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else if (hw > 0.0) {
            g2d.draw(new Arc2D.Double(dotN.x - hw, dotN.y, 2.0 * hw, h, -90.0, 180.0, 0));
        } else {
            g2d.draw(new Arc2D.Double(dot0.x, dotN.y, -2.0 * hw, h, 90.0, 180.0, 0));
        }
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double x = CONST_A * lambdaRad * (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        double y = CONST_A * 2.0 * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * 0.5 * this.invRS_ * INV_A;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double lambdaRad = x * INV_A * this.invRS_ / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Eckert3 eckert3 = this;
        synchronized (eckert3) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * 0.5 * this.invRS_ * INV_A) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double twoPhiOverPi = phiRad * 0.6366197723675814;
                double xFactor = INV_A * this.invRS_ / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

