/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hatano
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Hatano";
    public static final int PROPERTIES = 8;
    private static final double CSUBX = 0.85;
    private static final double CSUBY = 1.758587;
    private static final double CSUBP = 2.675945;
    private static final double CSUBYS = 1.930519;
    private static final double CSUBPS = 2.437625;
    private static final double INV_CY = 0.5686383443071057;
    private static final double INV_CP = 0.3736997584031062;
    private static final double INV_CYS = 0.5179954198844974;
    private static final double INV_CPS = 0.41023537254499765;
    private static final double MAX_THETA = 48.18967443209006;
    private static final double MAX_THETAS = 41.40961606708636;
    private static final double WIDTH_FACTOR = 2.670353755551324;
    private static final double HEIGHT_FACTOR = 1.758587 * Math.sin(Math.toRadians(48.18967443209006));
    private static final double HEIGHT_FACTORS = 1.930519 * Math.sin(Math.toRadians(41.40961606708636));
    private int dyMaxS_;
    private ProjBooleanParameter asymmParam_ = new ProjBooleanParameter("Show asymmetric form", "Asymmetric", true);
    private boolean asymmetric_;

    public Hatano(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hatano(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Hatano(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.670353755551324, HEIGHT_FACTOR);
        this.addParameter(this.asymmParam_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setAsymmetric(((ProjBooleanParameter)this.getParameter(0)).isSelected());
    }

    public void setAsymmetric(boolean b) {
        this.asymmetric_ = b;
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        this.dyMaxS_ = this.asymmetric_ ? -((int)(HEIGHT_FACTORS * this.rS_ + 0.5)) : -this.dyMax_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double cSubP = this.asymmetric_ && lat < 0.0 ? 2.437625 : 2.675945;
        double cSubY = this.asymmetric_ && lat < 0.0 ? 1.930519 : 1.758587;
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double cpSinPhi = cSubP * sinPhi;
        double thetaRad = 0.5 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - cpSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = cSubY * Math.sin(thetaRad);
        double x = 0.85 * this.lonToLambdaRad(lon) * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (y < (double)this.dyMaxS_) {
            return null;
        }
        double invCp = this.asymmetric_ && y < 0.0 ? 0.41023537254499765 : 0.3736997584031062;
        double yOverRS = y * this.invRS_;
        double invCy = this.asymmetric_ && y < 0.0 ? 0.5179954198844974 : 0.5686383443071057;
        double sinTheta = yOverRS * invCy;
        double thetaRad = Math.asin(sinTheta);
        double twoThetaRad = 2.0 * thetaRad;
        double sinPhi = (twoThetaRad + Math.sin(twoThetaRad)) * invCp;
        double phiRad = Math.asin(sinPhi);
        if (Double.isNaN(phiRad)) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double lambdaRad = xOverRS / (0.85 * Math.cos(thetaRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Hatano hatano = this;
        synchronized (hatano) {
            for (int iy = this.dyMaxS_; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                if (y < (double)this.dyMaxS_) continue;
                double invCp = this.asymmetric_ && y < 0.0 ? 0.41023537254499765 : 0.3736997584031062;
                double invCy = this.asymmetric_ && y < 0.0 ? 0.5179954198844974 : 0.5686383443071057;
                double yOverRS = y * this.invRS_;
                double sinTheta = yOverRS * invCy;
                double thetaRad = Math.asin(sinTheta);
                double twoThetaRad = 2.0 * thetaRad;
                double sinPhi = (twoThetaRad + Math.sin(twoThetaRad)) * invCp;
                double phiRad = Math.asin(sinPhi);
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / (0.85 * Math.cos(thetaRad));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set2SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier[] curves = this.makeOuterBezier();
        if (curves != null) {
            curves[0].draw(g2d);
            curves[1].draw(g2d);
        }
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_ + 180.0, 90.0);
        if (Math.abs(dot.x - (double)this.outCenterX_) < 1.0E-5) {
            return;
        }
        g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
        dot = this.transformLL2XY(this.lambdaC_ + 180.0, -90.0);
        if (Math.abs(dot.x - (double)this.outCenterX_) < 1.0E-5) {
            return;
        }
        g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y));
    }

    protected Bezier[] makeOuterBezier() {
        double edgeLon = this.lambdaC_ + 179.99999;
        int np = 270;
        double fact = 0.6666666666666666;
        Point2D.Double[] dotsE = new Point2D.Double[271];
        Point2D.Double[] dotsW = new Point2D.Double[271];
        for (int j = 0; j <= 270; ++j) {
            double lat = -90.0 + 0.6666666666666666 * (double)j;
            Point2D.Double dot = this.transformLL2XYIgnoreMargins(edgeLon, lat);
            if (dot == null) {
                LOGGER.debug("Got null XY for border lon {}, lat ", (Object)edgeLon, (Object)lat);
                return null;
            }
            dotsE[j] = new Point2D.Double(dot.x, dot.y);
            dotsW[j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        }
        Bezier[] curves = new Bezier[]{new Bezier(false, dotsE), new Bezier(false, dotsW)};
        return curves;
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 179.99999, lat);
        Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ + 179.99999, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot2.x - (double)fh2 - (double)w);
            g2d.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)(des / 2)));
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, dot1.x, dot1.y, dot2.x, dot1.y);
        g2d.setClip(oldclip);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
        if (absLambda > 179.99999) {
            return;
        }
        super.drawMeridian(g2d, lon, label);
    }
}

