/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

public enum Interruption {
    UNINTERRUPTED("Uninterrupted", -9999.0, new double[][][]{new double[][]{new double[0]}, new double[][]{new double[0]}}),
    CONTINENTS("Interrupted: Continents", 0.0, new double[][][]{new double[][]{{-180.0, -100.0, -40.0}, {-40.0, 30.0, 180.0}}, new double[][]{{-180.0, -160.0, -100.0}, {-100.0, -60.0, -20.0}, {-20.0, 20.0, 80.0}, {80.0, 140.0, 180.0}}}),
    CONTINENTS_MCBRYDE("Interrupted: Continents (McBryde)", 0.0, new double[][][]{new double[][]{{-180.0, -100.0, -30.0}, {-30.0, 30.0, 180.0}}, new double[][]{{-180.0, -60.0, -30.0}, {-30.0, 30.0, 90.0}, {90.0, 140.0, 180.0}}}),
    CONTINENTS_BAKER("Interrupted: Continents (Baker)", 0.0, new double[][][]{new double[][]{{-180.0, -100.0, -30.0}, {-30.0, 30.0, 180.0}}, new double[][]{{-180.0, -90.0, -15.0}, {-15.0, 30.0, 75.0}, {75.0, 135.0, 180.0}}}),
    OCEANS("Interrupted: Oceans", -160.0, new double[][][]{new double[][]{{20.0, 60.0, 110.0}, {110.0, -170.0, -100.0}, {-100.0, -30.0, 20.0}}, new double[][]{{20.0, 90.0, 140.0}, {140.0, -140.0, -70.0}, {-70.0, -20.0, 20.0}}}),
    OCEANS_MCBRYDE("Interrupted: Oceans (McBryde)", -180.0, new double[][][]{new double[][]{{0.0, 40.0, 110.0}, {110.0, -160.0, -100.0}, {-100.0, -40.0, 0.0}}, new double[][]{{0.0, 80.0, 140.0}, {140.0, -160.0, -70.0}, {-70.0, -20.0, 0.0}}}),
    HEMISPHERES("Interrupted: Hemispheres", -20.0, new double[][][]{new double[][]{{160.0, -110.0, -20.0}, {-20.0, 70.0, 160.0}}, new double[][]{{160.0, -110.0, -20.0}, {-20.0, 70.0, 160.0}}}),
    GORES_120("Interrupted: 120\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(120.0), Interruption.simpleGores(120.0)}),
    GORES_40("Interrupted: 40\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(40.0), Interruption.simpleGores(40.0)}),
    GORES_30("Interrupted: 30\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(30.0), Interruption.simpleGores(30.0)}),
    GORES_20("Interrupted: 20\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(20.0), Interruption.simpleGores(20.0)}),
    GORES_15("Interrupted: 15\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(15.0), Interruption.simpleGores(15.0)}),
    GORES_10("Interrupted: 10\u00b0 Gores", 0.0, new double[][][]{Interruption.simpleGores(10.0), Interruption.simpleGores(10.0)});

    private final String text_;
    private final double[][][] gores_;
    private final double center_;

    private Interruption(String text, double center, double[][][] gores) {
        this.text_ = text;
        this.center_ = center;
        this.gores_ = gores;
    }

    public String toString() {
        return this.text_;
    }

    public boolean nameMatches(String text) {
        return this.text_.equals(text);
    }

    public boolean nameMatchesIC(String text) {
        return this.text_.equalsIgnoreCase(text);
    }

    public double getCenterLongitude() {
        return this.center_;
    }

    public double[][][] getGores() {
        return this.gores_;
    }

    private static double[][] simpleGores(double goreWidth) {
        int numGores = (int)(360.0 / goreWidth);
        double halfWidth = 0.5 * goreWidth;
        double[][] result = new double[numGores][3];
        for (int i = 0; i < numGores; ++i) {
            result[i][0] = -180.0 + goreWidth * (double)i;
            result[i][1] = -180.0 + goreWidth * (double)i + halfWidth;
            result[i][2] = -180.0 + goreWidth * (double)(i + 1);
        }
        return result;
    }
}

