/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaurerS187
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Maurer SNo. 187 All-Globular";
    public static final int PROPERTIES = 0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.9634954084936207;
    private static final double LOBE_X_UNSCALED = 1.1780972450961724;

    public MaurerS187(int width, int height) {
        this(width, height, 0, 0);
    }

    public MaurerS187(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MaurerS187(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, Math.PI, 1.9634954084936207);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double absLambdaRad = Math.abs(lambdaRad);
        double absPhiRad = Math.abs(phiRad);
        double twoPhiRadOverPi = absPhiRad * 0.6366197723675814;
        double x = 0.0;
        double y = 0.0;
        if (absLambdaRad < 1.0E-5) {
            x = 0.0;
            y = absPhiRad;
        } else if (absPhiRad < 1.0E-5) {
            x = absLambdaRad;
            y = 0.0;
        } else if (absPhiRad > 1.5707963266948965) {
            x = 0.0;
            y = 1.5707963267948966;
        } else {
            double zRad;
            double rho = (Math.PI * Math.PI + 4.0 * absLambdaRad * absLambdaRad) / (8.0 * absLambdaRad);
            double x0 = absLambdaRad - rho;
            if (x0 < 0.0) {
                double sinZ = 1.5707963267948966 / rho;
                zRad = Math.asin(sinZ);
            } else {
                double sinCoZ = 1.5707963267948966 / rho;
                double coZRad = Math.asin(sinCoZ);
                zRad = Math.PI - coZRad;
            }
            double cRad = twoPhiRadOverPi * zRad;
            x = x0 + rho * Math.cos(cRad);
            y = rho * Math.sin(cRad);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (phiRad < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = absX * this.invRS_;
        double yOverRS = absY * this.invRS_;
        double[] lambdaPhi = this.transformUnscaledXYtoLambdaPhi(xOverRS, yOverRS);
        if (lambdaPhi == null) {
            return null;
        }
        double lambdaRad = lambdaPhi[0];
        double phiRad = lambdaPhi[1];
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        MaurerS187 maurerS187 = this;
        synchronized (maurerS187) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = Math.abs(y * this.invRS_);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = Math.abs(x * this.invRS_);
                    double[] lambdaPhi = this.transformUnscaledXYtoLambdaPhi(xOverRS, yOverRS);
                    if (lambdaPhi == null) {
                        if (!(yOverRS < 1.5707963267948966) && !(xOverRS > 1.1780972450961724)) continue;
                        continue block3;
                    }
                    double lambdaRad = lambdaPhi[0];
                    double phiRad = lambdaPhi[1];
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double[] transformUnscaledXYtoLambdaPhi(double x, double y) {
        double zRad;
        if (x > Math.PI || y > 1.9634954084936207) {
            return null;
        }
        if (x < 1.0E-10) {
            if (y > 1.5707963267948966) {
                return null;
            }
            return new double[]{x, y};
        }
        if (y < 1.0E-10) {
            return new double[]{0.0, y};
        }
        double x0 = 0.5 / x * (x * x + y * y - 2.4674011002723395);
        double rho0Sq = x0 * x0 + 2.4674011002723395;
        double rho0 = Math.sqrt(rho0Sq);
        double lambdaRad = x0 + rho0;
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        if (x0 < 0.0) {
            double sinZ = 1.5707963267948966 / rho0;
            zRad = Math.asin(sinZ);
        } else {
            double sinCoZ = 1.5707963267948966 / rho0;
            double coZRad = Math.asin(sinCoZ);
            zRad = Math.PI - coZRad;
        }
        double sinC = y / rho0;
        double cRad = Math.asin(sinC);
        if (zRad > 1.5707963267948966 && x < x0) {
            cRad = Math.PI - cRad;
        }
        double twoPhiRadOverPi = cRad / zRad;
        double phiRad = twoPhiRadOverPi * 1.5707963267948966;
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        double lona = this.lambdaC_ + 179.99999;
        double lonb = this.lambdaC_ + -179.99999;
        Point2D.Double dot1 = this.transformLL2XY(lona, 90.0);
        Point2D.Double dot2e = this.transformLL2XY(lona, 0.0);
        Point2D.Double dot2w = this.transformLL2XY(lonb, 0.0);
        Point2D.Double dot3 = this.transformLL2XY(lona, -90.0);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2e, dot3);
        GraphicUtils.drawCircularArc(g2d, dot1, dot2w, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        try {
            Point2D.Double dot1 = this.transformLL2XY(lon, 90.0);
            Point2D.Double dot2 = this.transformLL2XY(lon, 0.0);
            Point2D.Double dot3 = this.transformLL2XY(lon, -90.0);
            double absLambda = Math.abs(MapUtils.normalizeMP180(lon - this.lambdaC_));
            if (absLambda < 1.0E-5) {
                GraphicUtils.drawLine(g2d, dot1.x, dot1.y, dot3.x, dot3.y);
            } else {
                if (absLambda > 179.99999) {
                    return;
                }
                GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
            }
        }
        catch (Exception exc) {
            LOGGER.debug("Unable to draw meridian {}, {}", (Object)lon, (Object)exc.toString());
        }
    }
}

