/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP6P
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P6'";
    private static final double CONST_A = 0.886586;
    private static final double CONST_B = 0.804044;
    private static final double CONST_C = 6.928203230275509 - Math.log(3.732050807568877);
    private static final double INV_C = 1.0 / CONST_C;
    private static final double WIDTH_FACTOR = 2.78529206437556;
    private static final double HEIGHT_FACTOR = 1.3926450595209103;
    private double twoOverRSA_;
    private double invRSB_;

    public PutninsP6P(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP6P(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP6P(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.78529206437556, 1.3926450595209103);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        this.twoOverRSA_ = 2.0 * this.invRS_ / 0.886586;
        this.invRSB_ = this.invRS_ / 0.804044;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double cSinPhi = CONST_C * Math.sin(phiRad);
        double alpha = 1.7320508075688772 * (lat / 90.0);
        double sqrtOnePlusAlpha2 = 0.0;
        for (int iter = 0; iter < 33; ++iter) {
            sqrtOnePlusAlpha2 = Math.sqrt(1.0 + alpha * alpha);
            double dalpha = -(alpha * (6.0 - sqrtOnePlusAlpha2) - Math.log(alpha + sqrtOnePlusAlpha2) - cSinPhi) / (6.0 - 2.0 * sqrtOnePlusAlpha2);
            alpha += dalpha;
            if (Math.abs(dalpha) < 1.0E-5) break;
        }
        double x = 0.443293 * this.lonToLambdaRad(lon) * (3.0 - sqrtOnePlusAlpha2);
        double y = 0.804044 * alpha;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double alpha = y * this.invRSB_;
        double sqrtOnePlusAlpha2 = Math.sqrt(1.0 + alpha * alpha);
        double sinPhi = (alpha * (6.0 - sqrtOnePlusAlpha2) - Math.log(alpha + sqrtOnePlusAlpha2)) * INV_C;
        double phiRad = Math.asin(sinPhi);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.twoOverRSA_ / (3.0 - sqrtOnePlusAlpha2);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PutninsP6P putninsP6P = this;
        synchronized (putninsP6P) {
            double sqrtOnePlusAlpha2;
            double y;
            double alpha;
            double sinPhi;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(sinPhi = ((alpha = (y = (double)iy + 0.5) * this.invRSB_) * (6.0 - (sqrtOnePlusAlpha2 = Math.sqrt(1.0 + alpha * alpha))) - Math.log(alpha + sqrtOnePlusAlpha2)) * INV_C)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.twoOverRSA_ / (3.0 - sqrtOnePlusAlpha2);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

