/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class UrmayevSinusoidal
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Urmayev Sinusoidal";
    private static final double FOURTH_ROOT_OF_3 = Math.sqrt(1.7320508075688772);
    private static final double DEFAULT_B = 0.8660254037844386;
    private static final double CONST_A = 2.0 * FOURTH_ROOT_OF_3 / 3.0;
    private static final double INV_A = 1.0 / CONST_A;
    private static final double WIDTH_FACTOR = CONST_A * Math.PI;
    private static final double HEIGHT_FACTOR = Math.asin(0.8660254037844386) / (CONST_A * 0.8660254037844386);
    private double termB_ = 0.8660254037844386;
    private double invB_ = 1.0;
    private double aTimesB_ = 1.0;
    private double invAB_ = 1.0;
    private double aOverRS_ = 1.0;
    private double aBOverRS_ = 1.0;
    private double invARS_ = 1.0;

    public UrmayevSinusoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public UrmayevSinusoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public UrmayevSinusoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.addParameter(new ProjDoubleParameter("Pole-line parameter", "Pole-Line Param.", "(0\u2264b\u22641)", 0.75, 0.0, 1.0, true, true));
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setPoleLineParam(((ProjDoubleParameter)p).getValue());
    }

    public void setPoleLineParam(double b) {
        this.termB_ = b;
        this.aTimesB_ = CONST_A * this.termB_;
        this.invB_ = this.termB_ > 0.0 ? 1.0 / this.termB_ : 1.0E10;
        this.invAB_ = this.termB_ > 0.0 ? 1.0 / this.aTimesB_ : 1.0E10;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double heightFactor = this.termB_ > 0.0 ? Math.asin(this.termB_) * this.invAB_ : INV_A;
        this.setSizeFactors(WIDTH_FACTOR, heightFactor);
    }

    @Override
    protected final void finishScaling() {
        this.aOverRS_ = CONST_A * this.invRS_;
        this.aBOverRS_ = this.aTimesB_ * this.invRS_;
        this.invARS_ = INV_A * this.invRS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double sinPhi = Math.sin(phiRad);
        double lambdaRad = this.lonToLambdaRad(lon);
        if (this.termB_ == 0.0) {
            x = CONST_A * lambdaRad;
            y = INV_A * sinPhi;
        } else if (this.termB_ == 1.0) {
            x = CONST_A * lambdaRad * Math.cos(phiRad);
            y = INV_A * phiRad;
        } else {
            double thetaRad = Math.asin(this.termB_ * sinPhi);
            x = CONST_A * lambdaRad * Math.cos(thetaRad);
            y = this.invAB_ * thetaRad;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (this.termB_ == 0.0) {
            phiRad = Math.asin(y * this.aOverRS_);
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            lambdaRad = x * this.invARS_;
        } else if (this.termB_ == 1.0) {
            phiRad = y * this.aBOverRS_;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            if (Math.abs(phiRad) == 1.5707963267948966) {
                if (x != 0.0) return null;
                lambdaRad = 0.0;
            } else {
                lambdaRad = x * this.invARS_ / Math.cos(phiRad);
            }
        } else {
            double thetaRad = y * this.aBOverRS_;
            phiRad = Math.asin(Math.sin(thetaRad) * this.invB_);
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            lambdaRad = x * this.invARS_ / Math.cos(thetaRad);
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        UrmayevSinusoidal urmayevSinusoidal = this;
        synchronized (urmayevSinusoidal) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (this.termB_ == 0.0) {
                    phiRad = Math.asin(y * this.aOverRS_);
                    xFactor = this.invARS_;
                } else if (this.termB_ == 1.0) {
                    phiRad = y * this.aBOverRS_;
                    if (phiRad > 1.5707963267948966) break;
                    xFactor = phiRad == 1.5707963267948966 ? 0.0 : this.invARS_ / Math.cos(phiRad);
                } else {
                    double thetaRad = y * this.aBOverRS_;
                    phiRad = Math.asin(Math.sin(thetaRad) * this.invB_);
                    if (phiRad > 1.5707963267948966) break;
                    xFactor = this.invARS_ / Math.cos(thetaRad);
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

