/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerticalPerspective
extends AzimuthalProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Vertical Perspective";
    private static final double DEFAULT_D = 6.61;
    private double dPerspective_;
    private double invD_;
    private double dMinus1_;
    private ProjDoubleParameter distParam_ = new ProjDoubleParameter("Distance between observer and center of body", "Center Distance", "Radii (D>1)", 6.61, 1.0, Double.POSITIVE_INFINITY, false, true);

    public VerticalPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public VerticalPerspective(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public VerticalPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.distParam_);
        this.setFillCorners(false);
        this.autoscale();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.distParam_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setCenterDistance(this.distParam_.getValue());
    }

    public void setCenterDistance(double d) {
        this.dPerspective_ = d;
        this.dMinus1_ = this.dPerspective_ - 1.0;
        this.invD_ = 1.0 / this.dPerspective_;
        this.autoscale();
    }

    @Override
    public void setEdgeRadius(double r) {
        LOGGER.debug("Radius param not pertinent to this projection");
    }

    @Override
    public void setFillCorners(boolean fill) {
        LOGGER.debug("Fill param not pertinent to this projection");
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = Math.sqrt((this.dPerspective_ - 1.0) / (this.dPerspective_ + 1.0));
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ < this.invD_) {
            return -1.0;
        }
        return this.dMinus1_ / (this.dPerspective_ - cosZ);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        double rho = rhoRS * this.invRS_;
        double sqrtCapK = rho / this.dMinus1_;
        double capK = sqrtCapK * sqrtCapK;
        double capKPlus1 = capK + 1.0;
        double capKD = capK * this.dPerspective_;
        double sqrtTerm = capKPlus1 - capKD * this.dPerspective_;
        double cosZ = sqrtTerm > 0.0 ? (capKD + Math.sqrt(sqrtTerm)) / capKPlus1 : capKD / capKPlus1;
        return Math.acos(cosZ);
    }
}

