/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner3
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Wagner III";
    private static final double DEFAULT_PHITS = 0.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double phiTSFactor_;
    private ProjDoubleParameter phi1Param_ = new ProjDoubleParameter("Latitude of standard parallel", "Std. Parallel", "\u00b0N", 0.0, 0.0, 90.0, true, false);

    public Wagner3(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.phi1Param_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p != null && p != this.phi1Param_) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(this.phi1Param_.getValue());
    }

    public void setStandardParallel(double lat) {
        double phiTSRad = Math.toRadians(lat);
        double cosPhiTS = Math.cos(phiTSRad);
        double cos2PhiTSOver3 = Math.cos(phiTSRad * 2.0 / 3.0);
        this.phiTSFactor_ = cosPhiTS / cos2PhiTSOver3;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        this.setSizeFactors(Math.PI * this.phiTSFactor_, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double x = this.lonToLambdaRad(lon) * this.phiTSFactor_ * Math.cos(phiRad * 2.0 / 3.0);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRS_ / (this.phiTSFactor_ * Math.cos(phiRad * 2.0 / 3.0));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner3 wagner3 = this;
        synchronized (wagner3) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / (this.phiTSFactor_ * Math.cos(phiRad * 2.0 / 3.0));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

