/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Wagner8
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Wagner VIII";
    public static final int PROPERTIES = 32;
    private ProjListParameter varParam_ = new ProjListParameter("Variation", "Variation", (Object[])Variation.values(), 0);
    private Variation variation_;
    private double m1_;
    private double m2_;
    private double cn_;
    private double cx_;
    private double cy_;
    private double invCn_;
    private double invCx_;
    private double invCy_;

    public Wagner8(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner8(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wagner8(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(this.varParam_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        int varIndex = this.varParam_.getIndex();
        this.variation_ = Variation.values()[varIndex];
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double cosNLambda;
        this.m1_ = this.variation_.getM1();
        this.m2_ = this.variation_.getM2();
        this.cn_ = this.variation_.getN();
        this.cx_ = this.variation_.getCx();
        this.cy_ = this.variation_.getCy();
        this.invCn_ = 1.0 / this.cn_;
        this.invCx_ = 1.0 / this.cx_;
        this.invCy_ = 1.0 / this.cy_;
        double nLambdaRad = this.cn_ * Math.PI;
        double cosDelta = cosNLambda = Math.cos(nLambdaRad);
        double deltaRad = Math.acos(cosDelta);
        double d = Math.sin(0.5 * deltaRad);
        double wfactor = this.cx_ * d;
        nLambdaRad = this.cn_ * Math.PI;
        cosNLambda = Math.cos(nLambdaRad);
        double sinPsi = this.m1_ * Math.sin(this.m2_ * 1.5707963267948966);
        double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
        double cosDelta2 = cosPsi * cosNLambda;
        double sinDelta = Math.sqrt(1.0 - cosDelta2 * cosDelta2);
        double deltaRad2 = Math.acos(cosDelta2);
        double d2 = Math.sin(0.5 * deltaRad2);
        double cosAlpha = sinPsi / sinDelta;
        double hfactor = this.cy_ * d2 * cosAlpha;
        this.setSizeFactors(wfactor, hfactor);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double nLambdaRad = this.cn_ * lambdaRad;
        double cosNLambda = Math.cos(nLambdaRad);
        double sinPsi = this.m1_ * Math.sin(this.m2_ * phiRad);
        double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
        double cosDelta = cosPsi * cosNLambda;
        double sinDelta = Math.sqrt(1.0 - cosDelta * cosDelta);
        double deltaRad = Math.acos(cosDelta);
        double d = Math.sin(0.5 * deltaRad);
        double cosAlpha = sinPsi / sinDelta;
        double sinAlpha = Math.sqrt(1.0 - cosAlpha * cosAlpha);
        double x = this.cx_ * d * sinAlpha;
        double y = this.cy_ * d * cosAlpha;
        if (lambdaRad < 0.0) {
            x = 0.0 - x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverCx = x * this.invCx_;
        double yOverCy = y * this.invCy_;
        double d = Math.hypot(xOverCx, yOverCy) * this.invRS_;
        double phiRad = 0.0;
        double lambdaRad = 0.0;
        if (d > 1.0E-5) {
            if (Math.abs(phiRad) > this.m1_) {
                return null;
            }
            double delta = 2.0 * Math.asin(d);
            double sinPsi = yOverCy * this.invRS_ * Math.sin(delta) / d;
            phiRad = Math.asin(sinPsi / this.m1_) / this.m2_;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            if (Math.abs(phiRad) == 1.5707963267948966) {
                lambdaRad = 0.0;
            } else {
                double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
                lambdaRad = this.invCn_ * Math.acos(Math.cos(delta) / cosPsi);
                if (x < 0.0) {
                    lambdaRad = 0.0 - lambdaRad;
                }
            }
            if (lambdaRad > Math.PI) {
                return null;
            }
        }
        if (Double.isNaN(phiRad)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner8 wagner8 = this;
        synchronized (wagner8) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverCy = y * this.invCy_;
                double yOverCyRS = yOverCy * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double x = (double)ix + 0.5;
                    double xOverCx = x * this.invCx_;
                    double d = Math.hypot(xOverCx, yOverCy) * this.invRS_;
                    if (d > 1.0E-5) {
                        double delta = 2.0 * Math.asin(d);
                        double sinPsi = yOverCyRS * Math.sin(delta) / d;
                        if (sinPsi > this.m1_ || (phiRad = Math.asin(sinPsi / this.m1_) / this.m2_) > 1.5707963267948966) continue;
                        if (phiRad == 1.5707963267948966) {
                            lambdaRad = 0.0;
                        } else {
                            double cosPsi = Math.sqrt(1.0 - sinPsi * sinPsi);
                            lambdaRad = this.invCn_ * Math.acos(Math.cos(delta) / cosPsi);
                        }
                        if (lambdaRad > Math.PI) {
                            continue block3;
                        }
                    } else {
                        phiRad = 0.0;
                        lambdaRad = 0.0;
                    }
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static enum Variation {
        ORIGINAL("Wagner VIII", 65.0, 60.0, 60.0, 1.2, 2.0),
        CANTERS("Canters Optimization", 55.4366, 118.854, 60.0, 1.2, 1.9654),
        BOHM_1("B\u00f6hm Variation 1", 65.0, 84.0, 60.0, 1.25, 2.0),
        BOHM_2("B\u00f6hm Variation 2", 75.0, 108.0, 60.0, 1.0, 2.0),
        BOHM_3("B\u00f6hm Variation 3", 57.0, 105.0, 60.0, 1.2, 2.0),
        BOHM_4("B\u00f6hm Variation 4", 60.0, 132.0, 60.0, 1.0, 2.0);

        private String text_;
        private double varM1_;
        private double varM2_;
        private double varN_;
        private double varCx_;
        private double varCy_;

        private Variation(String text, double psi1, double lambda1, double phi1, double s60, double p) {
            this.text_ = text;
            double psi1rad = Math.toRadians(psi1);
            double lambda1rad = Math.toRadians(lambda1);
            double phi1rad = Math.toRadians(phi1);
            this.varM2_ = Math.acos(s60 * Math.cos(phi1rad)) / phi1rad;
            this.varM1_ = Math.sin(psi1rad) / Math.sin(this.varM2_ * 1.5707963267948966);
            this.varN_ = lambda1 / 180.0;
            double varK = Math.sqrt(p * Math.sin(0.5 * psi1rad) / Math.sin(0.5 * lambda1rad));
            this.varCx_ = 2.0 * varK / Math.sqrt(this.varN_ * this.varM1_ * this.varM2_);
            this.varCy_ = 2.0 / (varK * Math.sqrt(this.varN_ * this.varM1_ * this.varM2_));
        }

        double getM1() {
            return this.varM1_;
        }

        double getM2() {
            return this.varM2_;
        }

        double getN() {
            return this.varN_;
        }

        double getCx() {
            return this.varCx_;
        }

        double getCy() {
            return this.varCy_;
        }

        public String toString() {
            return this.text_;
        }

        public boolean nameMatches(String text) {
            return this.text_.equals(text);
        }

        public boolean nameMatchesIC(String text) {
            return this.text_.equalsIgnoreCase(text);
        }
    }
}

