/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Winkel2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Winkel II";
    private static final double COS_PHI1 = 0.6366197723675814;
    private static final double WIDTH_FACTOR = 2.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double FOUR_OVER_PI2 = 0.4052847345693511;

    public Winkel2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Winkel2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Winkel2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.5707963267948966, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiTerm = 0.6366197723675814 + Math.sqrt(1.0 - phiRad * phiRad * 0.4052847345693511);
        double xfactor = 0.5 * phiTerm;
        double x = lambdaRad * xfactor;
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double phiTerm = 0.6366197723675814 + Math.sqrt(1.0 - phiRad * phiRad * 0.4052847345693511);
        double xfactor = 2.0 * this.invRS_ / phiTerm;
        double lambdaRad = x * xfactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Winkel2 winkel2 = this;
        synchronized (winkel2) {
            double y;
            double phiRad;
            double twoOverRS = 2.0 * this.invRS_;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double phiTerm = 0.6366197723675814 + Math.sqrt(1.0 - phiRad * phiRad * 0.4052847345693511);
                double xFactor = twoOverRS / phiTerm;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

