/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.text.StringUtils;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjDoubleComponent
extends ProjParamComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 181L;
    private static final PrintfFormat NFORMAT = new PrintfFormat("%.4g");
    private ProjDoubleParameter parameter_;
    private JTextField tf_;

    public ProjDoubleComponent(ProjDoubleParameter parameter) {
        this(parameter, parameter.getDefault());
    }

    public ProjDoubleComponent(ProjDoubleParameter parameter, double value) {
        this(parameter, value, false);
    }

    public ProjDoubleComponent(ProjDoubleParameter parameter, double value, boolean padded) {
        super(parameter);
        this.parameter_ = parameter;
        this.createLayout(value, padded);
        this.attachListeners();
    }

    private void createLayout(double value, boolean padded) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getLabel() + ": ");
        nLabel.setOpaque(false);
        this.add(nLabel);
        this.tf_ = new JTextField(5);
        this.tf_.setHorizontalAlignment(4);
        this.setValue(value);
        this.add(this.tf_);
        String punits = this.parameter_.getUnits();
        if (punits != null && punits.length() > 0) {
            JLabel uLabel = new JLabel(punits);
            uLabel.setOpaque(false);
            this.add(uLabel);
        }
        if (padded) {
            this.add(Box.createHorizontalGlue());
        }
    }

    private void attachListeners() {
        this.tf_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ProjDoubleComponent.this.handleParam();
            }
        });
        this.tf_.addActionListener(e -> this.handleParam());
    }

    @Override
    public void reset() {
        this.tf_.setText(NFORMAT.sprintg(this.parameter_.getDefault()));
        this.handleParam();
    }

    @Override
    public String getStringValue() {
        return NFORMAT.sprintg(this.getValue());
    }

    public double getDoubleValue() {
        try {
            return StringUtils.parseDouble(this.tf_.getText());
        }
        catch (Exception exc) {
            return Double.NaN;
        }
    }

    @Override
    public Object getValue() {
        try {
            return StringUtils.parseDouble(this.tf_.getText());
        }
        catch (Exception exc) {
            return this.parameter_.getValue();
        }
    }

    @Override
    public void setValue(String sval) {
        Objects.requireNonNull(sval, "Value must not be null.");
        try {
            this.setValue(StringUtils.parseDouble(sval));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a Double: " + sval);
        }
    }

    public void setValue(double dval) {
        try {
            this.tf_.setText(NFORMAT.sprintg(dval));
            this.parameter_.setValue(dval);
        }
        catch (Exception exc) {
            LOGGER.warn("setValue {} : {}", (Object)dval, (Object)exc.toString());
            this.tf_.setText(NFORMAT.sprintg(this.parameter_.getValue()));
        }
        this.tf_.repaint();
        super.fireValueChanged();
    }

    @Override
    protected void handleParam() {
        try {
            double dval = StringUtils.parseDouble(this.tf_.getText());
            this.parameter_.setValue(dval);
        }
        catch (Exception exc) {
            LOGGER.warn(exc.toString());
            this.tf_.setText(NFORMAT.sprintg(this.parameter_.getValue()));
            this.tf_.repaint();
        }
        super.fireValueChanged();
    }
}

