/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.panoply.PanoplyCL;
import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.macos.PanMacApplication;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.server.PanClient;
import gov.nasa.giss.panoply.server.PanServer;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanDevoMode;
import gov.nasa.giss.panoply.util.PanLoggingUtils;
import gov.nasa.giss.panoply.util.PanNetcdfUtils;
import gov.nasa.giss.panoply.util.PanPrefsSaver;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanQuitWatcher;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVersionUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.EventQueue;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class Panoply {
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    private static long SPLASH_MILLIS = 2751L;
    private static long CLOSE_MILLIS = 4001L;
    private static long AUTOSAVE_MILLIS = 45011L;
    private static ArrayList<File> dataFiles_ = new ArrayList();
    private static String script_;
    private static boolean allowMulti_;
    private static boolean starting_;

    public static void main(String ... args) {
        starting_ = true;
        PanLoggingUtils.initLogging(PanDevoMode.isDevo());
        Panoply.parseCommandLineOptions(args);
        if (script_ != null) {
            Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
            logger.info("Script option detected: Diverting to PanoplyCL");
            new PanoplyCL(args);
            System.exit(0);
        }
        new Panoply();
    }

    private Panoply() {
        PanPreferences prefs;
        boolean isMacOS;
        Logger logger;
        block19: {
            logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
            String version = PanProperties.VERSION_PROPS.getString("version");
            String buildID = PanProperties.VERSION_PROPS.getString("build-id");
            logger.info("Panoply {} ({})", (Object)version, (Object)buildID);
            logger.info("{} {}", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.version"));
            logger.info("Java {}", (Object)System.getProperty("java.version"));
            isMacOS = PlatformUtils.isMacintosh();
            if (!allowMulti_ && !isMacOS && Panoply.isAlreadyRunning()) {
                logger.info("Panoply already running on this system. Exiting.");
                System.exit(0);
            }
            logger.trace("Set up default prefs");
            prefs = PanPreferences.getSharedInstance();
            logger.trace("Read prefs");
            prefs.read();
            logger.trace("Init util props");
            PanUtils.initProperties();
            try {
                if (!PlatformUtils.isLinuxEtc()) {
                    String lnfName = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(lnfName);
                }
            }
            catch (Exception exc) {
                logger.warn("Unable to install native look and feel");
            }
            logger.trace("Init netCDF utils");
            Hashtable<PanNetcdfUtils.Key, Object> initHash = new Hashtable<PanNetcdfUtils.Key, Object>();
            initHash.put(PanNetcdfUtils.Key.DEVO_MODE, PanDevoMode.isDevo());
            initHash.put(PanNetcdfUtils.Key.SERVER_MODE, false);
            PanNetcdfUtils.initNetcdf(initHash);
            if (isMacOS) {
                logger.trace("Initiating MacApplication adapters");
                try {
                    PanMacApplication.initiate();
                }
                catch (Exception exc) {
                    logger.error("Failed to init PanMacApplication.");
                    if (!logger.isDebugEnabled()) break block19;
                    exc.printStackTrace();
                }
            }
        }
        boolean noFiles = dataFiles_.isEmpty();
        long splashStop = -1L;
        if (noFiles) {
            logger.trace("No files provided in launch; show splash");
            splashStop = System.currentTimeMillis() + SPLASH_MILLIS;
            EventQueue.invokeLater(() -> PanAboutFrame.getSharedInstance().reveal());
        } else {
            logger.trace("Open {} files specified in launch", (Object)dataFiles_.size());
            for (File f : dataFiles_) {
                try {
                    if (f == null) continue;
                    PanFileUtils.openDataset(f);
                }
                catch (Exception exc) {
                    logger.warn("Skipping file {} -- {}", (Object)f.getName(), (Object)exc.toString());
                }
            }
        }
        if (splashStop > 0L) {
            logger.trace("Close splash");
            while (System.currentTimeMillis() < splashStop) {
                try {
                    Thread.sleep(101L);
                }
                catch (Exception exception) {}
            }
            EventQueue.invokeLater(() -> {
                PanAboutFrame paf = PanAboutFrame.getSharedInstance();
                paf.setVisible(false);
                paf.setLaunched(true);
            });
        }
        EventQueue.invokeLater(() -> {
            logger.trace("Show open filechooser if needed and if prefs say so?");
            if (noFiles && prefs.getBoolean("files:launch.dialog")) {
                File[] ff = PanFileUtils.showOpenDataFileChooser(null);
                if (ff != null) {
                    PanFileUtils.openLocalFiles(null, ff);
                }
            } else {
                logger.trace("... No, not needed.");
            }
        });
        EventQueue.invokeLater(() -> {
            logger.trace("Show Sources window");
            PanSourcesFrame.getSharedInstance().setVisible(true);
        });
        if (!isMacOS) {
            logger.trace("Start all-windows-closed quit watcher");
            new Timer().schedule((TimerTask)new PanQuitWatcher(), CLOSE_MILLIS, CLOSE_MILLIS);
        }
        logger.trace("Start prefs auto-save");
        new Timer().schedule((TimerTask)new PanPrefsSaver(), AUTOSAVE_MILLIS, AUTOSAVE_MILLIS);
        if (prefs.getBoolean("app:version.enabled")) {
            logger.trace("Check for updates");
            PanVersionUtils vc = PanVersionUtils.getSharedInstance();
            if (vc.isTimeForCheck()) {
                vc.checkForUpdate(false, true);
            }
        }
        starting_ = false;
    }

    private static void parseCommandLineOptions(String ... args) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        boolean optionsAllowed = true;
        String dataPath = null;
        ArrayList<String> dataFnames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].charAt(0) == '-') {
                if (args[i].equals("--")) {
                    optionsAllowed = false;
                    continue;
                }
                String optname = args[i].substring(1);
                if ("script".equals(optname)) {
                    if (++i >= args.length) {
                        logger.error(FATAL, "No value provided for script name.");
                        System.exit(1);
                    } else if (args[i].charAt(0) == '-') {
                        logger.error(FATAL, "Bad script specification '{}'.", (Object)args[i]);
                        System.exit(1);
                    } else {
                        script_ = args[i];
                    }
                    logger.info("Script command and filename detected.");
                    logger.info("Subsequent CL options will be ignored.");
                    return;
                }
                if ("loglevel".equals(optname)) {
                    if (++i >= args.length) {
                        logger.error(FATAL, "No value provided for loglevel.");
                        System.exit(1);
                        continue;
                    }
                    PanLoggingUtils.setLogLevel(args[i]);
                    continue;
                }
                if ("multi".equals(optname)) {
                    logger.trace("Found -multi.");
                    allowMulti_ = true;
                    continue;
                }
                if ("datapath".equals(optname)) {
                    logger.trace("Found -path");
                    if (dataPath != null) {
                        logger.warn("Path option specified > once; last choice wins.");
                    }
                    if (++i >= args.length) {
                        logger.error(FATAL, "No value provided for path option.");
                        System.exit(1);
                        continue;
                    }
                    if (args[i].charAt(0) == '-') {
                        logger.error(FATAL, "Bad path specification '{}'.", (Object)args[i]);
                        System.exit(1);
                        continue;
                    }
                    dataPath = args[i];
                    continue;
                }
                if (optname.startsWith("psn_")) {
                    logger.trace("Encountered macOS -psn -- ignoring it.");
                    continue;
                }
                if (optname.equals("NSDocumentRevisionsDebugMode")) {
                    logger.trace("Encountered macOS -NSDocumentRevisionsDebugMode; ignoring it.");
                    ++i;
                    continue;
                }
                logger.warn("Unknown command-line option {}; ignoring it", (Object)args[i]);
                continue;
            }
            logger.trace("Appending file name {}", (Object)args[i]);
            dataFnames.add(args[i]);
        }
        logger.trace("Found {} file names in command", (Object)dataFnames.size());
        if (dataFnames.size() > 0) {
            File dataPathdir = null;
            try {
                if (dataPath != null) {
                    dataPathdir = new File(dataPath);
                }
            }
            catch (Exception exc) {
                logger.error(FATAL, "Bad data path specification '{}'", (Object)dataPath);
                System.exit(2);
            }
            for (String fname : dataFnames) {
                if (!NcFilenameFilter.accept(fname)) {
                    logger.warn("Skipping '{}'. No recognized dataset filename extension.", (Object)fname);
                    continue;
                }
                try {
                    File f = new File(dataPathdir, fname);
                    if (f.exists()) {
                        dataFiles_.add(new File(dataPathdir, fname));
                        continue;
                    }
                    logger.warn("Skipping '{}'. File does not exist.", (Object)fname);
                }
                catch (Exception exc) {
                    logger.warn("Skipping '{}' due to {} ", (Object)fname, (Object)exc.toString());
                }
            }
        }
        logger.trace("File list includes {} objects", (Object)dataFiles_.size());
    }

    public static boolean isStarting() {
        return starting_;
    }

    private static boolean isAlreadyRunning() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        try {
            new PanClient(dataFiles_);
            logger.info("An instance of Panoply is already running on this computer.");
            return true;
        }
        catch (Exception exception) {
            try {
                PanServer.getSharedInstance().start();
            }
            catch (Exception exc) {
                logger.error("Could not init PanServer: {}", (Object)exc.toString());
            }
            return false;
        }
    }
}

