/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.cl.PCLFactory;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanDevoMode;
import gov.nasa.giss.panoply.util.PanLoggingUtils;
import gov.nasa.giss.panoply.util.PanNetcdfUtils;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.util.ResourceList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Objects;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PanoplyCL {
    private static final Marker FATAL = MarkerFactory.getMarker("FATAL");
    private static final String DEFAULT_SCRIPT_ENGINE_NAME = "JavaScript";

    public static void main(String ... args) {
        System.setProperty("java.awt.headless", Boolean.toString(true));
        new PanoplyCL(args);
    }

    PanoplyCL(String ... args) {
        PanLoggingUtils.initLogging(true);
        String version = PanProperties.VERSION_PROPS.getString("version");
        System.out.printf("PanoplyCL %s (%s)%n", version, PanProperties.VERSION_PROPS.getString("build-id"));
        PanUtils.initProperties();
        Hashtable<CLKey, Object> opts = PanoplyCL.parseCommandLineOptions(args);
        this.processCommandLineOptions(opts);
        this.initPrefs();
        boolean isServer = opts.containsKey((Object)CLKey.SERVER) && (Boolean)opts.get((Object)CLKey.SERVER) != false;
        Hashtable<PanNetcdfUtils.Key, Object> initHash = new Hashtable<PanNetcdfUtils.Key, Object>();
        initHash.put(PanNetcdfUtils.Key.DEVO_MODE, PanDevoMode.isDevo());
        initHash.put(PanNetcdfUtils.Key.SERVER_MODE, isServer);
        initHash.put(PanNetcdfUtils.Key.HEADLESS, true);
        if (opts.containsKey((Object)CLKey.GRIB_MODE)) {
            boolean lenient = "lenient".equalsIgnoreCase((String)opts.get((Object)CLKey.GRIB_MODE));
            initHash.put(PanNetcdfUtils.Key.GRIB_STRICT, !lenient);
        }
        PanNetcdfUtils.initNetcdf(initHash);
        ScriptEngine engine = this.initScriptEngine(opts);
        PCLFactory factory = PCLFactory.getSharedInstance();
        engine.put("panoply", factory);
        PanoplyCL.evaluateScript(engine, opts);
        PanoplyCL.quit();
    }

    private static Hashtable<CLKey, Object> parseCommandLineOptions(String ... args) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        boolean optionsAllowed = true;
        Hashtable<CLKey, Object> opts = new Hashtable<CLKey, Object>(12);
        for (int i = 0; i < args.length; ++i) {
            if (optionsAllowed && args[i].charAt(0) == '-') {
                String optname;
                if (args[i].equals("--")) {
                    optionsAllowed = false;
                    continue;
                }
                switch (optname = args[i].substring(1).toLowerCase()) {
                    case "gui": {
                        logger.info("-gui flag set.");
                        opts.put(CLKey.GUI, true);
                        break;
                    }
                    case "loglevel": {
                        if (++i >= args.length) {
                            logger.error(FATAL, "No value provided for log level");
                            System.exit(1);
                        }
                        PanLoggingUtils.setLogLevel(args[i]);
                        opts.put(CLKey.LOG_LEVEL, args[i]);
                        break;
                    }
                    case "engine": 
                    case "engine-name": {
                        if (opts.containsKey((Object)CLKey.ENGINE_NAME)) {
                            logger.error(FATAL, "Script engine name cannot be set twice");
                            System.exit(1);
                        }
                        if (++i >= args.length) {
                            logger.error(FATAL, "No value provided for -engine option");
                            System.exit(1);
                        }
                        opts.put(CLKey.ENGINE_NAME, args[i]);
                        break;
                    }
                    case "engine-path": {
                        if (++i >= args.length) {
                            logger.error(FATAL, "No value provided for -engine option");
                            System.exit(1);
                        }
                        opts.put(CLKey.ENGINE_PATH, args[i]);
                        break;
                    }
                    case "engine-list": {
                        opts.put(CLKey.ENGINE_LIST, true);
                        break;
                    }
                    case "script": {
                        if (opts.containsKey((Object)CLKey.SCRIPT_PATH)) {
                            logger.error(FATAL, "Script name cannot be set twice");
                            System.exit(1);
                        }
                        if (++i >= args.length) {
                            logger.error(FATAL, "No value provided for -script option");
                            System.exit(1);
                        }
                        opts.put(CLKey.SCRIPT_PATH, args[i]);
                        break;
                    }
                    case "server": {
                        logger.info("-server flag set.");
                        opts.put(CLKey.SERVER, true);
                        break;
                    }
                    case "grib": {
                        opts.put(CLKey.GRIB_MODE, true);
                        if (++i >= args.length) {
                            logger.error(FATAL, "No value provided for -grib option");
                            System.exit(1);
                        }
                        opts.put(CLKey.GRIB_MODE, args[i]);
                        break;
                    }
                    default: {
                        logger.warn("Unknown option {}", (Object)optname);
                        break;
                    }
                }
                continue;
            }
            if (opts.containsKey((Object)CLKey.SCRIPT_PATH)) {
                logger.warn("More than one script specified; ignoring all but the first.");
                continue;
            }
            opts.put(CLKey.SCRIPT_PATH, args[i]);
        }
        if (!opts.containsKey((Object)CLKey.GUI)) {
            opts.put(CLKey.GUI, false);
        }
        return opts;
    }

    private final void processCommandLineOptions(Hashtable<CLKey, Object> options) {
        String mode;
        if (options.containsKey((Object)CLKey.LOG_LEVEL)) {
            String llevel = (String)options.get((Object)CLKey.LOG_LEVEL);
            PanLoggingUtils.setLogLevel(llevel);
        }
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (options.containsKey((Object)CLKey.SERVER) && options.containsKey((Object)CLKey.GUI)) {
            Boolean isServer = (Boolean)options.get((Object)CLKey.SERVER);
            Boolean isGui = (Boolean)options.get((Object)CLKey.GUI);
            if (isServer.booleanValue() && isGui.booleanValue()) {
                logger.warn("Setting -server and -gui flags both true is contradictory.");
                logger.warn("I am re-setting the -gui flag to false.");
                options.put(CLKey.GUI, false);
            }
        }
        if (options.containsKey((Object)CLKey.GRIB_MODE) && !"lenient".equalsIgnoreCase(mode = (String)options.get((Object)CLKey.GRIB_MODE)) && !"strict".equalsIgnoreCase(mode)) {
            logger.warn("Unknown value specified for grib option. Using 'strict' instead.");
            options.put(CLKey.GRIB_MODE, "strict");
        }
        if (options.containsKey((Object)CLKey.SERVER) && ((Boolean)options.get((Object)CLKey.SERVER)).booleanValue()) {
            logger.info("Running in server mode...");
            logger.info("  If working with GRIB data, index files will be written to same directory as data.");
            logger.info("  This may cause errors if process does not have write access to disk.");
            PanPreferences.disablePreferencesFile();
            logger.info("  Prefs file usage has been disabled.");
            ResourceList.disableAppSupportDirectory();
            logger.info("  Colorbar and overlay support directory usage has been disabled.");
            logger.trace("  Pre-initializating graphics... ");
            GraphicUtils.preInitializeGraphics();
        }
        if (options.containsKey((Object)CLKey.GUI) && ((Boolean)options.get((Object)CLKey.GUI)).booleanValue()) {
            System.setProperty("java.awt.headless", Boolean.toString(false));
        }
    }

    private final void initPrefs() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        prefs.setBoolean("beta:numberlays", false);
    }

    private ScriptEngine initScriptEngine(Hashtable<CLKey, Object> options) {
        ScriptEngineFactory sef;
        ScriptEngine engine;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String epath = null;
        boolean elist = false;
        String ename = null;
        ScriptEngineManager sem = null;
        if (options.containsKey((Object)CLKey.ENGINE_PATH)) {
            epath = (String)options.get((Object)CLKey.ENGINE_PATH);
        }
        if (options.containsKey((Object)CLKey.ENGINE_LIST)) {
            elist = (Boolean)options.get((Object)CLKey.ENGINE_LIST);
        }
        ename = options.containsKey((Object)CLKey.ENGINE_NAME) ? (String)options.get((Object)CLKey.ENGINE_NAME) : DEFAULT_SCRIPT_ENGINE_NAME;
        if (epath != null) {
            logger.trace("Attempting to create class-loader for {}", (Object)epath);
            try {
                File file = new File(".", epath);
                URL url = file.toURI().toURL();
                URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
                logger.trace("Attempting to create script engine manager for {}", (Object)classLoader);
                sem = new ScriptEngineManager(classLoader);
                logger.trace(". Got {}", (Object)sem);
            }
            catch (Exception exc) {
                logger.error(FATAL, "Failed creating script engine manager: {}", (Object)exc.toString());
                if (logger.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                System.exit(1);
            }
        }
        if (sem == null) {
            sem = new ScriptEngineManager();
        }
        if (elist) {
            PanoplyCL.printEngineList(sem);
            System.exit(0);
        }
        if ((engine = sem.getEngineByName(ename)) == null) {
            logger.error(FATAL, "ScriptEngineManager found no engine for '{}'", (Object)ename);
            System.exit(1);
        }
        if ((sef = engine.getFactory()) == null) {
            logger.error(FATAL, "ScriptEngine returned null factory.");
            System.exit(1);
        }
        return engine;
    }

    private static void printEngineList(ScriptEngineManager sem) {
        System.err.println("Scripting engines available include:");
        for (ScriptEngineFactory sef : sem.getEngineFactories()) {
            System.err.printf("Engine %s, Language %s%n", sef.getEngineName(), sef.getLanguageName());
            for (String sname : sef.getNames()) {
                System.err.printf("   Has short name: %s%n", sname);
            }
        }
    }

    private static void evaluateScript(ScriptEngine engine, Hashtable<CLKey, Object> options) {
        String spath = null;
        if (options.containsKey((Object)CLKey.SCRIPT_PATH)) {
            spath = (String)options.get((Object)CLKey.SCRIPT_PATH);
        }
        if (spath != null) {
            PanoplyCL.evaluateScript(engine, spath);
        } else {
            PanoplyCL.evaluateLineByLine(engine);
        }
    }

    private static void evaluateScript(ScriptEngine engine, String spath) {
        Objects.requireNonNull(engine, "Script engine is null.");
        Objects.requireNonNull(spath, "Script path is null.");
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        File sfile = null;
        try {
            sfile = new File(spath);
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not create File object from '{}' -- {}", (Object)spath, (Object)exc);
            System.exit(2);
        }
        if (sfile == null) {
            logger.error(FATAL, "Script File object cannot be null.");
            System.exit(2);
        } else if (!sfile.exists()) {
            logger.error(FATAL, "No file found at script path '{}'", (Object)spath);
            System.exit(2);
        }
        BufferedReader breader = null;
        try {
            FileInputStream fstream = new FileInputStream(sfile);
            InputStreamReader ireader = new InputStreamReader((InputStream)fstream, "UTF-8");
            breader = new BufferedReader(ireader);
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not create script Reader: {}", exc);
            System.exit(2);
        }
        if (breader == null) {
            logger.error(FATAL, "Could not create script Reader. Null buffer.");
            System.exit(2);
        }
        try {
            engine.eval(breader);
        }
        catch (ScriptException exc) {
            PanoplyCL.printException(exc);
        }
        catch (IllegalArgumentException exc) {
            PanoplyCL.printException(exc);
        }
        catch (Exception exc) {
            PanoplyCL.printException(exc);
        }
        try {
            breader.close();
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not close script Reader: {}", exc);
            System.exit(2);
        }
    }

    private static void evaluateLineByLine(ScriptEngine engine) {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        InputStreamReader r = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(r);
        block4: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    String ss = br.readLine();
                    if (ss == null || ss.equalsIgnoreCase("qq") || ss.equalsIgnoreCase("quit") || ss.equalsIgnoreCase("bye") || ss.equalsIgnoreCase(".")) {
                        System.out.println("Done.");
                        break block4;
                    }
                    engine.eval(ss);
                }
            }
            catch (Exception exc) {
                PanoplyCL.printException(exc);
                continue;
            }
            break;
        }
        try {
            br.close();
        }
        catch (Exception exc) {
            logger.error(FATAL, "Could not close input Reader: {}", exc);
            System.exit(2);
        }
    }

    private static void printException(Exception exc) {
        PanoplyCL.printException(exc.toString());
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        if (logger.isDebugEnabled()) {
            exc.printStackTrace();
        }
    }

    private static void printException(String excStr) {
        String s = excStr;
        s = s.replaceFirst(".*EvaluatorException: ", "");
        s = s.replaceFirst(".*IllegalArgumentException: ", "");
        s = s.replaceFirst(".*NumberFormatException: ", "");
        s = s.replaceFirst(".*WrappedException: Wrapped ", "");
        s = s.replaceFirst("\\(<Unknown source>\\#\\d*\\) in <Unknown source> ", "");
        s = s.replaceFirst("gov\\.nasa\\.giss\\.panoply\\.cl\\.", "");
        s = s.replaceFirst("\\. at line", " at line");
        s = s.replaceFirst(" at line number", " at script line");
        s = s.substring(0, 1).toUpperCase() + s.substring(1);
        System.err.println("ScriptException: " + s);
    }

    public static void quit() {
        System.exit(0);
    }

    public static enum CLKey {
        SERVER("Server"),
        GUI("UseGui"),
        ENGINE_NAME("EngineName"),
        ENGINE_PATH("EnginePath"),
        ENGINE_LIST("EngineList"),
        SCRIPT_PATH("ScriptPath"),
        LOG_LEVEL("LogLevel"),
        GRIB_MODE("GribMode");


        private CLKey(String value) {
        }
    }
}

