/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.about;

import gov.nasa.giss.panoply.action.PanShowHelpPageAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.ClickableLinkMouseListener;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.ui.plaf.EmphasizedLabelUI;
import gov.nasa.giss.ui.plaf.EmphasizedMultiLineLabelUI;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public final class PanAboutFrame
extends PanFrame {
    private boolean launched_;

    public static PanAboutFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanAboutFrame() {
        this.setTitle(PanProperties.ABOUT_PROPS.getString("about-title"));
        this.setName(this.getTitle());
        this.setResizable(false);
        this.setUndecorated(true);
        this.createLayout();
        this.placeOnScreen();
    }

    private final void createLayout() {
        Font lfont = UIManager.getDefaults().getFont("Label.font");
        Font plain10 = lfont.deriveFont(0, 10.0f);
        Font plain12 = lfont.deriveFont(0, 12.0f);
        Font plain14 = lfont.deriveFont(0, 14.0f);
        Font bold18 = lfont.deriveFont(1, 18.0f);
        Font bold24 = lfont.deriveFont(1, 24.0f);
        JLabel iconLabel = null;
        try {
            iconLabel = new JLabel(new ImageIcon(PanAboutFrame.class.getResource("panoply4.png")));
            iconLabel.setAlignmentX(0.5f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JLabel titleLabel = new JLabel(PanProperties.VERSION_PROPS.getString("application-name"), 0);
        JLabel versionLabel = new JLabel(PanProperties.VERSION_PROPS.getString("version-word") + " " + PanProperties.VERSION_PROPS.getString("version"), 0);
        MultiLineLabel buildLabel = new MultiLineLabel(PanProperties.VERSION_PROPS.getString("build-word") + " " + PanProperties.VERSION_PROPS.getString("build-id") + "\n" + PanProperties.VERSION_PROPS.getString("build-date"), 0);
        JLabel gissLabel = new JLabel("NASA/GISS", 0);
        MultiLineLabel authorLabel = new MultiLineLabel(PanProperties.ABOUT_PROPS.getString("author"), 0);
        MultiLineLabel creditsLabel = new MultiLineLabel(PanProperties.ABOUT_PROPS.getString("credits"), 0);
        JLabel javaLabel = new JLabel(System.getProperty("os.name") + " " + System.getProperty("os.version") + " \u2014 Java " + System.getProperty("java.version"), 0);
        JLabel memLabel = new JLabel("Max memory " + Runtime.getRuntime().maxMemory() / 1000L / 1000L + " MB", 0);
        if (iconLabel != null) {
            iconLabel.setOpaque(false);
        }
        if (PlatformUtils.isMacintoshDarkMode()) {
            GuiUtils.applyHudUI(titleLabel);
            GuiUtils.applyHudUI(versionLabel);
            GuiUtils.applyHudUI(buildLabel);
            GuiUtils.applyHudUI(gissLabel);
            GuiUtils.applyHudUI(authorLabel);
            GuiUtils.applyHudUI(creditsLabel);
            GuiUtils.applyHudUI(javaLabel);
            GuiUtils.applyHudUI(memLabel);
        } else if (PlatformUtils.isMacintosh()) {
            titleLabel.setUI(new EmphasizedLabelUI());
            versionLabel.setUI(new EmphasizedLabelUI());
            buildLabel.setUI(new EmphasizedMultiLineLabelUI());
            gissLabel.setUI(new EmphasizedLabelUI());
            authorLabel.setUI(new EmphasizedMultiLineLabelUI());
            creditsLabel.setUI(new EmphasizedMultiLineLabelUI());
            javaLabel.setUI(new EmphasizedLabelUI());
            memLabel.setUI(new EmphasizedLabelUI());
        } else {
            titleLabel.setOpaque(false);
            versionLabel.setOpaque(false);
            gissLabel.setOpaque(false);
            authorLabel.setOpaque(false);
            creditsLabel.setOpaque(false);
            javaLabel.setOpaque(false);
            memLabel.setOpaque(false);
        }
        titleLabel.setFont(bold24);
        versionLabel.setFont(plain14);
        buildLabel.setFont(plain10);
        gissLabel.setFont(bold18);
        authorLabel.setFont(plain12);
        creditsLabel.setFont(plain12);
        javaLabel.setFont(plain10);
        memLabel.setFont(plain10);
        titleLabel.setAlignmentX(0.5f);
        versionLabel.setAlignmentX(0.5f);
        buildLabel.setAlignmentX(0.5f);
        gissLabel.setAlignmentX(0.5f);
        authorLabel.setAlignmentX(0.5f);
        creditsLabel.setAlignmentX(0.5f);
        javaLabel.setAlignmentX(0.5f);
        memLabel.setAlignmentX(0.5f);
        Box contentBox = new Box(1);
        contentBox.setOpaque(true);
        Border innerBorder = BorderFactory.createEmptyBorder(19, 19, 19, 19);
        if (PlatformUtils.isMacintoshDarkMode()) {
            contentBox.setBackground(new Color(50, 52, 57));
            contentBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), innerBorder));
        } else {
            contentBox.setBackground(new Color(232, 232, 232));
            contentBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), innerBorder));
        }
        if (iconLabel != null) {
            contentBox.add(iconLabel);
            contentBox.add(Box.createVerticalStrut(8));
        }
        contentBox.add(titleLabel);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(versionLabel);
        contentBox.add(Box.createVerticalStrut(4));
        contentBox.add(buildLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(gissLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(authorLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(creditsLabel);
        contentBox.add(Box.createVerticalStrut(6));
        contentBox.add(javaLabel);
        contentBox.add(memLabel);
        this.getContentPane().add(contentBox);
        this.pack();
        gissLabel.addMouseListener(new ClickableLinkMouseListener(PanProperties.ABOUT_PROPS.getString("giss-url")));
        creditsLabel.addMouseListener(new PanShowHelpPageAction(PanProperties.ABOUT_PROPS.getString("credits-url")));
    }

    public void setLaunched(boolean launched) {
        this.launched_ = launched;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.launched_ && this.getPanMenuBar() == null) {
            this.setPanMenuBar(new PanMenuBar(this));
            this.pack();
        }
        super.setVisible(visible);
    }

    private static class Singleton {
        private static final PanAboutFrame INSTANCE = new PanAboutFrame();

        private Singleton() {
        }
    }
}

