/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action.dialog;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanCommonComboBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanPanel;
import gov.nasa.giss.panoply.util.PanAnimationFormat;
import gov.nasa.giss.panoply.util.PanAnimationOption;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanExportAnimationDialog
extends JDialog {
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private final PanPlotFrame pframe_;
    private PanPanel slicesPanel_;
    private PanPanel morePanel_;
    private PanCommonComboBox formatCombo_;
    private PanIntSpinner frateSpinner_;
    private PanIntSpinner qspinner_;
    private PanCheckBox subtitleCB_;
    private PanCheckBox subBoundsCB_;
    private PanIntSpinner startSpinner_;
    private PanIntSpinner stopSpinner_;
    private PanIntSpinner strideSpinner_;
    private PanCheckBox moreOptCB_;
    private JButton cancelButton_;
    private JButton makeButton_;
    private NcDimension[] dimensions_ = new NcDimension[2];
    private boolean success_;

    public PanExportAnimationDialog(PanPlotFrame pframe) {
        super(pframe, "Animation Options", true);
        this.pframe_ = pframe;
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
        this.refresh();
        this.stopSpinner_.setValue(this.stopSpinner_.getMaximum());
    }

    private final void createLayout() {
        this.formatCombo_ = PanCommonComboBox.create(null, (Object[])PanAnimationFormat.values());
        PanAnimationFormat format = PanAnimationFormat.MP4;
        this.formatCombo_.setSelectedItem((Object)format);
        String fext = PREFS.getString("files:save.animation.extension");
        for (PanAnimationFormat form : PanAnimationFormat.values()) {
            if (!form.getExtension().equals(fext)) continue;
            format = form;
            this.formatCombo_.setSelectedItem((Object)form);
            break;
        }
        QuickBox formatBox = QuickBox.createLeftBox(this.formatCombo_);
        this.formatCombo_.setMaximumSize(this.formatCombo_.getPreferredSize());
        this.frateSpinner_ = PanIntSpinner.create(1, 1, 100, 1);
        this.frateSpinner_.setMaximum(48);
        this.frateSpinner_.setValue(PREFS.getInt("files:save.animation.frate"));
        this.frateSpinner_.setEnabled(format.isVideo());
        QuickBox frateBox = QuickBox.createLeftBox(this.frateSpinner_, PanLabel.create("fps"));
        this.qspinner_ = PanIntSpinner.createPct(0);
        int quality = Math.min(100, PREFS.getInt("files:save.animation.quality"));
        quality = Math.max(quality, 10);
        this.qspinner_.setValue(quality);
        this.qspinner_.setEnabled(format.canReduceQuality());
        this.slicesPanel_ = this.makeSlicesPanel();
        this.cancelButton_ = new JButton("Cancel");
        this.makeButton_ = new JButton("Okay");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelButton_, this.makeButton_) : QuickBox.createRightBox(this.makeButton_, this.cancelButton_);
        PanPanel contentPanel = new PanPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(2, 25, 0, 0);
        fgl.setColumnWeight(1, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int row = 0;
        contentPanel.add((Component)PanLabel.create("Format: "), new FGConstraint(0, row));
        contentPanel.add((Component)formatBox, new FGConstraint(1, row));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, ++row));
        contentPanel.add((Component)PanLabel.create("Frame Rate: "), new FGConstraint(0, ++row));
        contentPanel.add((Component)frateBox, new FGConstraint(1, row));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, ++row));
        contentPanel.add((Component)PanLabel.create("Quality: "), new FGConstraint(0, ++row));
        contentPanel.add((Component)this.qspinner_, new FGConstraint(1, row));
        contentPanel.add(Box.createVerticalStrut(12), new FGConstraint(0, ++row));
        contentPanel.add((Component)this.slicesPanel_, new FGConstraint(0, ++row, 2, 1));
        contentPanel.add(Box.createVerticalStrut(2), new FGConstraint(0, ++row));
        contentPanel.add(Box.createVerticalStrut(16), new FGConstraint(1, ++row, 1.0));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, ++row, 2, 1, 1.0, 0.5));
        ++row;
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.makeButton_);
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            EventQueue.invokeLater(() -> this.makeButton_.requestFocusInWindow());
        }
        super.setVisible(vis);
    }

    private PanPanel makeSlicesPanel() {
        PanPanel spanel0 = null;
        PanPanel spanel1 = null;
        PanData data = this.pframe_.getData();
        PanCombinationType ctype = data.getCombinationType();
        if (ctype == PanCombinationType.A1_ONLY) {
            spanel0 = this.makeSlicePanel(0, false);
        } else if (ctype == PanCombinationType.A2_ONLY) {
            spanel1 = this.makeSlicePanel(1, false);
        } else {
            spanel0 = this.makeSlicePanel(0, true);
            spanel1 = this.makeSlicePanel(1, true);
        }
        this.morePanel_ = this.makeMorePanel();
        this.subtitleCB_ = PanCheckBox.create("Show dimension info as frame sub-title ", PREFS.getBoolean("files:save.animation.subtitles.vis"));
        this.subBoundsCB_ = PanCheckBox.createSmall("Take frame info from dimension bounds", PREFS.getString("files:save.animation.subtitles.type").equalsIgnoreCase("bounds"));
        this.moreOptCB_ = PanCheckBox.createSmall("Show more options", PREFS.getBoolean("files:save.animation.options"));
        this.subtitleCB_.setPreferredSize(null);
        Dimension d = this.subtitleCB_.getPreferredSize();
        d.width += 12;
        this.subtitleCB_.setPreferredSize(d);
        this.subtitleCB_.setMinimumSize(d);
        this.subtitleCB_.setMaximumSize(d);
        QuickBox sbBox = QuickBox.createLeftBox(Box.createHorizontalStrut(24), this.subBoundsCB_);
        PanPanel panel = new PanPanel();
        panel.setBorder(new TitledBorder("Frame Content"));
        panel.setLayout(new BoxLayout(panel, 1));
        if (spanel0 != null) {
            panel.add(spanel0);
            spanel0.setAlignmentX(0.0f);
        }
        if (spanel0 != null && spanel1 != null) {
            panel.add(Box.createVerticalStrut(2));
        }
        if (spanel1 != null) {
            panel.add(spanel1);
            spanel1.setAlignmentX(0.0f);
        }
        panel.add(Box.createVerticalStrut(2));
        panel.add(new JSeparator());
        panel.add(Box.createVerticalStrut(2));
        panel.add(this.subtitleCB_);
        panel.add(Box.createVerticalStrut(2));
        panel.add(sbBox);
        panel.add(Box.createVerticalStrut(4));
        panel.add(this.moreOptCB_);
        this.subtitleCB_.setAlignmentX(0.0f);
        this.subBoundsCB_.setAlignmentX(0.0f);
        sbBox.setAlignmentX(0.0f);
        this.moreOptCB_.setAlignmentX(0.0f);
        if (this.moreOptCB_.isSelected()) {
            panel.add(this.morePanel_);
            this.morePanel_.setAlignmentX(0.0f);
        }
        return panel;
    }

    private PanPanel makeSlicePanel(int vnum, boolean multi) {
        PanData data = this.pframe_.getData();
        NcArray ncarray = data.getArray(vnum);
        if (ncarray == null) {
            return null;
        }
        PanPanel panel = new PanPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setName("[animation panel " + vnum + "]");
        PanLabel titleLabel = null;
        StringBuilder sb = new StringBuilder("Array ").append(vnum + 1);
        if (ncarray != null) {
            sb.append(": ").append(ncarray.getShortName());
        }
        titleLabel = PanLabel.create(sb.toString());
        panel.add(QuickBox.createLeftBox(titleLabel));
        ButtonGroup bgroup = new ButtonGroup();
        boolean selectedIsSet = false;
        if (ncarray == null) {
            panel.add(PanLabel.create("None selected"));
        } else {
            int dcount = 0;
            for (NcDimension ncdim : ncarray.getFreeDimensions()) {
                if (ncdim == null) continue;
                ++dcount;
                DimensionButton button = new DimensionButton(ncdim, vnum);
                if (!selectedIsSet) {
                    ((AbstractButton)button).setSelected(true);
                    selectedIsSet = true;
                } else {
                    ((AbstractButton)button).setSelected(false);
                }
                panel.add(QuickBox.createLeftBox(button));
                bgroup.add(button);
            }
            if (dcount == 0) {
                panel.add(PanLabel.create("No additional dimensions"));
            }
        }
        if (multi) {
            DimensionButton button = new DimensionButton(null, vnum);
            panel.add(QuickBox.createLeftBox(button));
            bgroup.add(button);
        }
        return panel;
    }

    private PanPanel makeMorePanel() {
        this.startSpinner_ = PanIntSpinner.createSmall(1, 1, 9999, 1);
        this.stopSpinner_ = PanIntSpinner.createSmall(1, 1, 9999, 1);
        this.strideSpinner_ = PanIntSpinner.createSmall(1, 1, 9999, 1);
        PanLabel startLabel = PanLabel.createSmall("Start Index: ");
        PanLabel stopabel = PanLabel.createSmall("End Index: ");
        PanLabel strideLabel = PanLabel.createSmall("Stride: ");
        GuiUtils.matchLabelWidths(startLabel, stopabel, strideLabel);
        QuickBox box1 = QuickBox.createLeftBox(Box.createHorizontalStrut(24), startLabel, this.startSpinner_);
        QuickBox box2 = QuickBox.createLeftBox(Box.createHorizontalStrut(24), stopabel, this.stopSpinner_);
        QuickBox box3 = QuickBox.createLeftBox(Box.createHorizontalStrut(24), strideLabel, this.strideSpinner_);
        PanPanel panel = new PanPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(2));
        panel.add(box1);
        panel.add(box2);
        panel.add(box3);
        box1.setAlignmentX(0.0f);
        box2.setAlignmentX(0.0f);
        box3.setAlignmentX(0.0f);
        return panel;
    }

    private final void refresh() {
        if (this.startSpinner_ == null) {
            return;
        }
        int newmax = -1;
        boolean bounds0 = false;
        boolean bounds1 = false;
        if (this.dimensions_[0] != null) {
            newmax = Math.max(newmax, this.dimensions_[0].getLength());
            bounds0 = this.dimensions_[0].hasBounds();
        }
        if (this.dimensions_[1] != null) {
            newmax = Math.max(newmax, this.dimensions_[1].getLength());
            bounds1 = this.dimensions_[0].hasBounds();
        }
        if (newmax == -1) {
            newmax = 1;
        }
        boolean boundsEnabled = false;
        boundsEnabled = this.dimensions_[0] == null ? bounds1 : (this.dimensions_[1] == null ? bounds0 : bounds0 && bounds1);
        this.subBoundsCB_.setEnabled(boundsEnabled);
        int startVal = this.startSpinner_.getIntValue();
        if (startVal > newmax) {
            this.startSpinner_.setValue(newmax);
        }
        this.startSpinner_.setMaximum(newmax);
        int stopVal = this.stopSpinner_.getIntValue();
        if (stopVal > newmax) {
            this.stopSpinner_.setValue(newmax);
        }
        this.stopSpinner_.setMaximum(newmax);
        this.stopSpinner_.setValue(newmax);
        int strideVal = this.strideSpinner_.getIntValue();
        if (strideVal > newmax) {
            this.strideSpinner_.setValue(newmax);
        }
        this.strideSpinner_.setMaximum(newmax);
    }

    private final void attachListeners() {
        this.formatCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            PanAnimationFormat af = (PanAnimationFormat)((Object)((Object)this.formatCombo_.getSelectedItem()));
            this.frateSpinner_.setEnabled(af.isVideo());
            this.qspinner_.setEnabled(af.canReduceQuality());
        });
        this.moreOptCB_.addItemListener(e -> {
            boolean bb = this.moreOptCB_.isSelected();
            if (bb) {
                this.slicesPanel_.add(this.morePanel_);
                this.morePanel_.setAlignmentX(0.0f);
            } else {
                this.slicesPanel_.remove(this.morePanel_);
            }
            this.pack();
            this.repaint();
            PREFS.setBoolean("files:save.animation.options", bb);
        });
        this.makeButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanExportAnimationDialog.this.success_ = true;
                PREFS.set("files:save.animation.extension", ((PanAnimationFormat)((Object)PanExportAnimationDialog.this.formatCombo_.getSelectedItem())).getExtension());
                PREFS.setInt("files:save.animation.frate", PanExportAnimationDialog.this.frateSpinner_.getIntValue());
                PREFS.setInt("files:save.animation.quality", PanExportAnimationDialog.this.qspinner_.getIntValue());
                PREFS.setBoolean("files:save.animation.subtitles.vis", PanExportAnimationDialog.this.subtitleCB_.isSelected());
                if (PanExportAnimationDialog.this.subBoundsCB_.isSelected()) {
                    PREFS.set("files:save.animation.subtitles.type", "bounds");
                } else {
                    PREFS.set("files:save.animation.subtitles.type", "value");
                }
                PanExportAnimationDialog.this.setVisible(false);
            }
        });
        this.cancelButton_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public Hashtable<PanAnimationOption, Object> getOptions() {
        Hashtable<PanAnimationOption, Object> opts = new Hashtable<PanAnimationOption, Object>(12);
        opts.put(PanAnimationOption.FORMAT, (Object)((PanAnimationFormat)((Object)this.formatCombo_.getSelectedItem())));
        opts.put(PanAnimationOption.FRAME_RATE, this.frateSpinner_.getIntValue());
        opts.put(PanAnimationOption.QUALITY, this.qspinner_.getIntValue());
        opts.put(PanAnimationOption.SUBTITLE_STEP, this.subtitleCB_.isSelected());
        opts.put(PanAnimationOption.SUBTITLE_BOUNDS, this.subBoundsCB_.isSelected());
        opts.put(PanAnimationOption.START_INDEX, this.startSpinner_.getIntValue());
        opts.put(PanAnimationOption.STOP_INDEX, this.stopSpinner_.getIntValue());
        opts.put(PanAnimationOption.STRIDE, this.strideSpinner_.getIntValue());
        return opts;
    }

    public NcDimension[] getDimensions() {
        return this.dimensions_;
    }

    class DimensionButton
    extends JRadioButton {
        private final NcDimension ncdim_;
        private final int vnum_;

        DimensionButton(NcDimension ncdim, int vnum) {
            this.ncdim_ = ncdim;
            this.vnum_ = vnum;
            StringBuilder sb = new StringBuilder();
            if (ncdim == null) {
                sb.append("None (Leave fixed) ");
            } else {
                sb.append(ncdim.getLongName()).append(" (").append(ncdim.getLength()).append(" frames) ");
            }
            this.setText(sb.toString());
            this.addActionListener(e -> {
                if (this.isSelected()) {
                    ((PanExportAnimationDialog)PanExportAnimationDialog.this).dimensions_[this.vnum_] = this.ncdim_;
                    PanExportAnimationDialog.this.refresh();
                }
            });
        }

        NcDimension getDimension() {
            return this.ncdim_;
        }

        @Override
        public void setSelected(boolean selected) {
            if (selected) {
                ((PanExportAnimationDialog)PanExportAnimationDialog.this).dimensions_[this.vnum_] = this.ncdim_;
            }
            super.setSelected(selected);
        }
    }
}

