/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.bookmarks;

import gov.nasa.giss.panoply.bookmarks.PanBookmarkNode;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.util.Objects;

public class PanBookmarkFolder
extends PanBookmarkNode {
    public PanBookmarkFolder(PanBookmarkNode parent, String name) {
        this.setParent(parent);
        this.setName(name);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        return "Unnamed Folder";
    }

    @Override
    public String getAddress() {
        int isize = this.getChildCount();
        if (isize == 1) {
            return "1 item";
        }
        return this.getChildCount() + " items";
    }

    @Override
    public void add(TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanBookmarkNode)) {
            throw new IllegalArgumentException("Child must be a PanBookmarkNode.");
        }
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanBookmarkNode)) {
            throw new IllegalArgumentException("Child must be a PanBookmarkNode.");
        }
        super.add(index, child);
    }
}

