/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.bookmarks;

import gov.nasa.giss.panoply.bookmarks.PanBookmark;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkFolder;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkNode;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanHistoryFolder
extends PanBookmarkFolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PrintfFormat PFORMAT_2D = new PrintfFormat("%02d");
    private static final PrintfFormat PFORMAT_4D = new PrintfFormat("%04d");
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("EEEE, MMMM dd, yyyy");
    private LocalDate calDate_ = LocalDate.now();
    private int year_;
    private int month_;
    private int day_;

    private PanHistoryFolder(PanBookmarkNode parent) {
        super(parent, null);
    }

    public PanHistoryFolder(PanBookmarkNode parent, String date) {
        this(parent);
        String ys = date.substring(0, 4);
        String ms = date.substring(4, 6);
        String ds = date.substring(6, 8);
        if (ms.charAt(0) == '0') {
            ms = ms.substring(1, 2);
        }
        if (ds.charAt(0) == '0') {
            ds = ds.substring(1, 2);
        }
        this.year_ = Integer.parseInt(ys);
        this.month_ = Integer.parseInt(ms);
        this.day_ = Integer.parseInt(ds);
        this.calDate_ = LocalDate.of(this.year_, this.month_, this.day_);
    }

    public PanHistoryFolder(PanBookmarkNode parent, int year, int month, int day) {
        this(parent);
        this.year_ = year;
        this.month_ = month;
        this.day_ = day;
        this.calDate_ = LocalDate.of(this.year_, this.month_, day);
    }

    public boolean isTodayFolder() {
        LocalDate offsetLDT = LocalDate.now();
        int year = offsetLDT.getYear();
        int month = offsetLDT.getMonthValue();
        int day = offsetLDT.getDayOfMonth();
        int[] date = this.getDate();
        return date[0] == year && date[1] == month && date[2] == day;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        if (this.isTodayFolder()) {
            return "Earlier Today";
        }
        DateTimeFormatter dateTimeFormatter = DATE_FORMAT;
        synchronized (dateTimeFormatter) {
            return this.calDate_.format(DATE_FORMAT);
        }
    }

    @Override
    public boolean isNameSet() {
        return false;
    }

    public int getAge() {
        LocalDate today = LocalDate.now();
        long diffDays = ChronoUnit.DAYS.between(this.calDate_, today);
        return (int)diffDays;
    }

    public int[] getDate() {
        return new int[]{this.year_, this.month_, this.day_};
    }

    public String getDateString() {
        return PFORMAT_4D.sprintf((Object)this.year_) + PFORMAT_2D.sprintf((Object)this.month_) + PFORMAT_2D.sprintf((Object)this.day_);
    }

    @Override
    public void add(TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanBookmark)) {
            throw new IllegalArgumentException("Can only add a PanBookmark to a day folder.");
        }
        this.removeExistingDuplicate((PanBookmark)child);
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanBookmark)) {
            throw new IllegalArgumentException("Can only add a PanBookmark to a day folder.");
        }
        this.removeExistingDuplicate((PanBookmark)child);
        super.add(index, child);
    }

    private final void removeExistingDuplicate(PanBookmark node) {
        int isize = this.getChildCount();
        if (isize == 0) {
            return;
        }
        URI u1 = PanHistoryFolder.getURI(node.getObject());
        if (u1 == null) {
            return;
        }
        for (int i = 0; i < isize; ++i) {
            URI u2 = PanHistoryFolder.getURI(((PanBookmarkNode)this.getChildAt(i)).getObject());
            if (!u1.equals(u2)) continue;
            super.remove(i);
            return;
        }
    }

    private static URI getURI(Object o) {
        block5: {
            try {
                if (o instanceof File) {
                    return ((File)o).toURI();
                }
                if (o instanceof URL) {
                    return ((URL)o).toURI();
                }
                if (o instanceof URI) {
                    return (URI)o;
                }
            }
            catch (Exception exc) {
                LOGGER.warn("getURI error, returning null");
                if (!LOGGER.isTraceEnabled()) break block5;
                exc.printStackTrace();
            }
        }
        return null;
    }

    public PanHistoryFolder copy() {
        PanHistoryFolder result = new PanHistoryFolder(null, this.year_, this.month_, this.day_);
        int isize = this.getChildCount();
        if (isize == 0) {
            return result;
        }
        for (int i = 0; i < isize; ++i) {
            PanBookmark b;
            TreeTableNode child = this.getChildAt(i);
            if (!(child instanceof PanBookmark) || (b = ((PanBookmark)child).copy()) == null) continue;
            result.add(b);
        }
        return result;
    }
}

