/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLatTime;
import gov.nasa.giss.panoply.data.PanDataXTime;
import java.awt.Dimension;

public class PanDataLatTime
extends PanDataXTime {
    public PanDataLatTime(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataLatTime(NcArray nca, int gridWidth, int gridHeight) {
        super(nca, gridWidth, gridHeight);
        this.setGridLeftAndRight(-90.0, 90.0);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayLatTime)) {
            throw new IllegalArgumentException("NcArray not NcArrayLatTime.");
        }
        return true;
    }

    @Override
    public String getXAxisName() {
        return "Latitude";
    }

    @Override
    public String getDataXAxisUnits() {
        return "degree_north";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_north";
    }
}

