/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanPlotHeightAction;
import gov.nasa.giss.panoply.action.PanShorterPlotAction;
import gov.nasa.giss.panoply.action.PanTallerPlotAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotHeight;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class PanPlotHeightMenu
extends PanMenu {
    private final JMenuItem miCurrentHeight_;
    private final JMenuItem miTaller_;
    private final JMenuItem miShorter_;
    private final Hashtable<String, JCheckBoxMenuItem> miPresetsHash_ = new Hashtable(20);

    public PanPlotHeightMenu(PanFrame parent) {
        super(parent, "plot-height-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        this.miCurrentHeight_ = this.makeItemFromProperties("current-height", null);
        this.add(this.miCurrentHeight_).setEnabled(false);
        this.addSeparator();
        AbstractAction a = parentIsPlot ? new PanTallerPlotAction((PanPlotFrame)parent) : null;
        this.miTaller_ = this.makeItemFromProperties("show-taller", a);
        this.add(this.miTaller_).setEnabled(false);
        a = parentIsPlot ? new PanShorterPlotAction((PanPlotFrame)parent) : null;
        this.miShorter_ = this.makeItemFromProperties("show-shorter", a);
        this.add(this.miShorter_).setEnabled(false);
        this.addSeparator();
        for (PanPlotHeight pheight : PanPlotHeight.values()) {
            String aid = pheight.getActionID();
            String atext = pheight.toString();
            PanPlotHeightAction a2 = parentIsPlot && aid != null ? new PanPlotHeightAction((PanPlotFrame)parent, pheight) : null;
            GissCheckBoxMenuItem mi = aid != null ? this.makeCheckBoxItemFromProperties(aid, a2) : this.makeCheckBoxItem(atext, a2);
            this.miPresetsHash_.put(atext, mi);
            this.add(mi).setEnabled(parentIsPlot);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        JFrame pf = GuiUtils.getParentFrame(this);
        if (!(pf instanceof PanPlotFrame)) {
            return;
        }
        int hf = ((PanPlotFrame)pf).getHeightFactor();
        this.miCurrentHeight_.setText(PanProperties.MENU_PROPS.getString("current-height") + " = " + hf);
        this.miTaller_.setEnabled(hf < 400);
        this.miShorter_.setEnabled(hf > 20);
        for (String key : this.miPresetsHash_.keySet()) {
            JCheckBoxMenuItem mi = this.miPresetsHash_.get(key);
            String text = mi.getText();
            PanPlotHeight pheight = PanPlotHeight.matching(text);
            if (pheight == null) {
                mi.setSelected(false);
                continue;
            }
            mi.setSelected(pheight.getHeightFactor() == hf);
        }
    }
}

