/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.action.PanMinimizeFrameAction;
import gov.nasa.giss.panoply.action.PanShowAboutFrameAction;
import gov.nasa.giss.panoply.action.PanShowColorTableFrameAction;
import gov.nasa.giss.panoply.action.PanShowOverlayFrameAction;
import gov.nasa.giss.panoply.action.PanShowPreferencesFrameAction;
import gov.nasa.giss.panoply.action.PanShowSourcesFrameAction;
import gov.nasa.giss.panoply.colortable.PanColorTableFrame;
import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.overlay.PanOverlayFrame;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.menu.GissCheckBoxMenuItem;
import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Window;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;

public class PanWindowMenu
extends PanMenu {
    private final JCheckBoxMenuItem miShowSources_;
    private final JCheckBoxMenuItem miShowColorTables_;
    private final JCheckBoxMenuItem miShowOverlays_;
    private final JCheckBoxMenuItem miPreferences_;
    private final JCheckBoxMenuItem miAbout_;
    private final int coreItemsCount_;

    public PanWindowMenu(PanFrame parent) {
        super(parent, "window-menu");
        AbstractAction a = new PanMinimizeFrameAction(this.pframe_);
        GissMenuItem jmi = this.makeItemFromProperties("minimize-window", a);
        this.add(jmi);
        if (PlatformUtils.isMacintosh()) {
            jmi.setEnabled(!(parent instanceof PanHiddenMacFrame));
        } else {
            jmi.setEnabled(true);
        }
        this.addSeparator();
        a = PanShowSourcesFrameAction.getSharedInstance();
        this.miShowSources_ = this.makeCheckBoxItemFromProperties("show-sources-window", a);
        this.add(this.miShowSources_).setEnabled(true);
        a = PanShowColorTableFrameAction.getSharedInstance();
        this.miShowColorTables_ = this.makeCheckBoxItemFromProperties("show-colorbar-window", a);
        this.add(this.miShowColorTables_).setEnabled(true);
        a = PanShowOverlayFrameAction.getSharedInstance();
        this.miShowOverlays_ = this.makeCheckBoxItemFromProperties("show-overlay-window", a);
        this.add(this.miShowOverlays_).setEnabled(true);
        this.coreItemsCount_ = this.getItemCount();
        if (PlatformUtils.isMacintosh()) {
            this.miPreferences_ = null;
            this.miAbout_ = null;
        } else {
            PanShowPreferencesFrameAction a1 = PanShowPreferencesFrameAction.getSharedInstance();
            PanShowAboutFrameAction a2 = PanShowAboutFrameAction.getSharedInstance();
            this.miPreferences_ = this.makeCheckBoxItemFromProperties("show-preferences-2", a1);
            this.miAbout_ = this.makeCheckBoxItemFromProperties("show-about", a2);
            this.add(this.miPreferences_).setEnabled(true);
            this.add(this.miAbout_).setEnabled(true);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        int msize = this.getItemCount();
        for (int i = this.coreItemsCount_; i < msize; ++i) {
            this.remove(this.coreItemsCount_);
        }
        this.miShowSources_.setSelected(window instanceof PanSourcesFrame);
        this.miShowColorTables_.setSelected(window instanceof PanColorTableFrame);
        this.miShowOverlays_.setSelected(window instanceof PanOverlayFrame);
        PanPlotFrame[] plotFrames = PanGuiUtils.getPlotFrames();
        if (plotFrames.length > 0) {
            this.addSeparator();
            PanPlotFrame[] panPlotFrameArray = plotFrames;
            int n = panPlotFrameArray.length;
            for (int i = 0; i < n; ++i) {
                PanPlotFrame pf;
                PanPlotFrame ff = pf = panPlotFrameArray[i];
                GissCheckBoxMenuItem mi = this.makeCheckBoxItem(ff.getTitle(), null);
                mi.addActionListener(e -> {
                    ff.reveal();
                    mi.setSelected(true);
                });
                this.add(mi).setEnabled(true);
                mi.setSelected(ff == window);
            }
        }
        if (this.miPreferences_ != null || this.miAbout_ != null) {
            this.addSeparator();
            if (this.miPreferences_ != null) {
                this.add(this.miPreferences_).setEnabled(true);
                this.miPreferences_.setSelected(window instanceof PanPreferencesFrame);
            }
            if (this.miAbout_ != null) {
                this.add(this.miAbout_).setEnabled(true);
                this.miAbout_.setSelected(window instanceof PanAboutFrame);
            }
        }
    }
}

