/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.Contours2D;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.plot.PanDataImage;
import gov.nasa.giss.panoply.plot.PanPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleColorbar;
import gov.nasa.giss.panoply.util.PanUtils;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanPlot2D
extends PanPlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PanDataImage dataImage_;
    protected PanScaleColorbar colorbar_;
    protected Contours2D contours_;
    protected int contourWeight_;
    protected boolean needsRecontour_ = true;

    public PanPlot2D(PanPlotMeta pmeta) {
        super(pmeta);
        PanData data = pmeta.getData();
        this.colorbar_ = new PanScaleColorbar(pmeta, data);
        if (data instanceof PanData2D) {
            PanData2D data2D = (PanData2D)data;
            this.contours_ = new Contours2D(data2D);
        }
        this.attach(this.colorbar_);
        this.parameterChangedPrivate("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        PanData data = this.pmeta_.getData();
        if (data instanceof PanData2D) {
            PanData2D data2D = (PanData2D)data;
            this.dataImage_ = new PanDataImage(this.pmeta_, data2D);
        }
        this.needsDataRedraw_ = true;
    }

    @Override
    protected void prepareToPaint() {
        super.prepareToPaint();
        boolean cbvis = this.pmeta_.getBoolean("include.scale");
        this.colorbar_.setVisible(cbvis);
        Rectangle scaleRect = (Rectangle)this.pmeta_.getLayout().getParam("bounds.scale");
        this.colorbar_.setSize(scaleRect.width, scaleRect.height);
        if (cbvis) {
            this.colorbar_.setLocation(scaleRect.x, scaleRect.y);
        } else {
            this.colorbar_.setLocation(-scaleRect.width, -scaleRect.height);
        }
    }

    protected void paintDataImage(boolean knockout) {
        this.dataImage_.paintData(knockout);
        this.needsDataRedraw_ = false;
    }

    @Override
    public String getExtremaDescription() {
        StringBuilder sb = new StringBuilder("Data ");
        sb.append("Min = ");
        sb.append(this.colorbar_.getFormatter().sprintg(this.data_.getMinValue()));
        sb.append(", ");
        sb.append("Max = ");
        sb.append(this.colorbar_.getFormatter().sprintg(this.data_.getMaxValue()));
        return sb.toString();
    }

    @Override
    public void dataChanged(PanDataEvent e) {
        this.needsDataRedraw_ = true;
        this.needsRecontour_ = true;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private final void parameterChangedPrivate(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("interpolate") || pname.contains("scale.method")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("scale.colorbar") || pname.contains("scale.reverse") || pname.contains("scale.invalids")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("scale.div.major") || pname.contains("scale.div.minor")) {
            this.needsRecontour_ = true;
        }
        if ((changeAll || pname.contains("contour.color") || pname.contains("contour.weight") || pname.contains("contour.style") || pname.contains("contour.location") || changeAll) && !this.ptype_.isFeatureType()) {
            String s = this.pmeta_.getString("contour.style");
            int oldOpacity = this.contourWeight_;
            this.contourWeight_ = s.toLowerCase().contains("none") ? 0 : PanUtils.min0max(500, this.pmeta_.getInt("contour.weight"));
            if (oldOpacity == 0 && this.contourWeight_ > 0) {
                this.needsRecontour_ = true;
            }
        }
        if ((changeAll || pname.contains("contour.location")) && !this.ptype_.isFeatureType()) {
            this.needsRecontour_ = true;
        }
    }

    public PanScaleColorbar getColorbar() {
        Rectangle scaleRect = (Rectangle)this.pmeta_.getLayout().getParam("bounds.scale");
        this.colorbar_.setSize(scaleRect.width, scaleRect.height);
        return this.colorbar_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PanPlot2D panPlot2D = this;
        synchronized (panPlot2D) {
            super.flush();
            if (this.dataImage_ != null) {
                this.dataImage_.flush();
            }
            this.contours_ = null;
            this.dataImage_ = null;
            this.colorbar_ = null;
        }
    }
}

