/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanDataGeneral2D;
import gov.nasa.giss.panoply.data.PanDataTime1D;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanZoomableAxisControls;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCommonXAxisControls
extends PanZoomableAxisControls {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static Hashtable<String, String> paramKeys_ = new Hashtable();

    public PanCommonXAxisControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("grid-xaxis-controls", pmeta, mbar);
        this.createLayout(paramKeys_);
    }

    @Override
    protected final boolean isHorizontal() {
        return true;
    }

    @Override
    protected NcAxisType getAxisType() {
        switch (this.plotType_) {
            case LAT_VERT: 
            case LAT_TIME: {
                this.axisHasNegAlt_ = true;
                return NcAxisType.LAT;
            }
            case LON_VERT: 
            case LON_TIME: {
                this.axisHasNegAlt_ = true;
                return NcAxisType.LON;
            }
            case LON_LAT: {
                return NcAxisType.LAT;
            }
            case TIME_LAT: 
            case TIME_VERT: {
                this.axisIsTime_ = true;
                return NcAxisType.TIME;
            }
            case GENERAL_2D: 
            case HORZ_LINE: {
                break;
            }
            case VERT_LINE: {
                throw new RuntimeException("Cannot create X axis controls for a vertical line plot");
            }
            default: {
                LOGGER.trace("Switch - How did we get here? {}", (Object)this.plotType_);
            }
        }
        try {
            if (this.data_ instanceof PanData1D) {
                PanData1D data1d = (PanData1D)this.data_;
                this.axisIsTime_ = this.data_ instanceof PanDataTime1D;
                this.axisIsPressure_ = data1d.isAxisPressure();
                this.axisIsHeight_ = data1d.isAxisHeight();
            } else if (this.data_ instanceof PanDataGeneral2D) {
                PanDataGeneral2D data2d = (PanDataGeneral2D)this.data_;
                this.axisIsPressure_ = data2d.isXAxisPressure();
                this.axisIsHeight_ = data2d.isXAxisHeight();
            }
            if (this.axisIsTime_) {
                return NcAxisType.TIME;
            }
            NcAxisType atype = this.plotType_.getAxes()[0];
            if (atype == NcAxisType.TIME) {
                this.axisIsTime_ = true;
            }
            return atype;
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot determine X axis type.");
        }
    }

    @Override
    public void resetAxisBounds() {
        double val2;
        double val1;
        PanAxisMethod method = PanAxisMethod.matching(this.pmeta_.getString("xaxis.method"));
        PanPreferences prefs = PanPreferences.getSharedInstance();
        switch (this.plotType_) {
            case LAT_TIME: {
                val1 = prefs.getDouble("plot:lattime.xaxis.left");
                val2 = prefs.getDouble("plot:lattime.xaxis.right");
                break;
            }
            case LON_TIME: {
                val1 = prefs.getDouble("plot:lontime.xaxis.left");
                val2 = prefs.getDouble("plot:lontime.xaxis.right");
                break;
            }
            case LAT_VERT: {
                val1 = prefs.getDouble("plot:latvert.xaxis.left");
                val2 = prefs.getDouble("plot:latvert.xaxis.right");
                break;
            }
            case LON_VERT: {
                val1 = prefs.getDouble("plot:lonvert.xaxis.left");
                val2 = prefs.getDouble("plot:lonvert.xaxis.right");
                break;
            }
            case LON_LAT: {
                if (this.pmeta_.isLonLatZonal()) {
                    val1 = prefs.getDouble("plot:lonlat.zonal.xaxis.left");
                    val2 = prefs.getDouble("plot:lonlat.zonal.xaxis.right");
                    break;
                }
                val1 = -90.0;
                val2 = 90.0;
                break;
            }
            case HORZ_LINE: {
                double[] range = ((PanData1D)this.data_).getDefaultAxisRange(method);
                val1 = range[0];
                val2 = range[1];
                break;
            }
            case VERT_LINE: {
                return;
            }
            default: {
                PanDataGeneral2D data = (PanDataGeneral2D)this.data_;
                double[] range = data.getDefaultLeftAndRight(method);
                val1 = range[0];
                val2 = range[1];
            }
        }
        this.setAxisBounds(val1, val2);
    }

    static {
        paramKeys_.put("axis.begin", "xaxis.left");
        paramKeys_.put("axis.end", "xaxis.right");
        paramKeys_.put("axis.method", "xaxis.method");
        paramKeys_.put("axis.units", "xaxis.units");
        paramKeys_.put("axis.units.alt", "xaxis.units.alt");
        paramKeys_.put("axis.div.major", "xaxis.div.major");
        paramKeys_.put("axis.div.minor", "xaxis.div.minor");
        paramKeys_.put("axis.tick.format", "xaxis.tick.format");
        paramKeys_.put("axis.tick.size", "xaxis.tick.size");
        paramKeys_.put("axis.label.custom", "xaxis.label.custom");
        paramKeys_.put("axis.label.text", "xaxis.label.text");
        paramKeys_.put("axis.label.size", "xaxis.label.size");
        paramKeys_.put("swap-axis-bounds", "swap-xbounds");
    }
}

