/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanAbstractControlsPanel;
import gov.nasa.giss.panoply.plotui.PanCommonXAxisControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanColorComboBox;
import gov.nasa.giss.panoply.ui.PanEnumComboBox;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanRadioButton;
import gov.nasa.giss.panoply.ui.PanTextField;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanStrokeStyle;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatZonalControls
extends PanAbstractControlsPanel
implements PlotPropertyListener {
    private PanEnumComboBox gridStyleCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanIntSpinner tickWeightSpinner_;
    private PanColorComboBox s1ColorCombo_;
    private PanEnumComboBox s1StyleCombo_;
    private PanIntSpinner s1WeightSpinner_;
    private PanRadioButton dfltS1CapButton_;
    private PanRadioButton userS1CapButton_;
    private PanTextField s1CaptionTF_;

    public PanLonLatZonalControls(PanPlotMeta pmeta, PanMenuBar mbar) {
        super("lonlat-zonal-controls", pmeta, mbar);
        this.createLayout();
        this.attachListeners();
        this.pmeta_.addPlotPropertyListener(this);
    }

    private final void createLayout() {
        PanLabel gStyleLabel = PanLabel.createSmall("Grid Style: ");
        this.gridStyleCombo_ = PanEnumComboBox.createSmall("grid.style", PanStrokeStyle.class);
        this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        PanLabel gWeightLabel = PanLabel.createSmall(", Weight: ");
        this.gridWeightSpinner_ = PanIntSpinner.createSmallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 200);
        PanLabel gPctLabel = PanLabel.createSmall("%");
        this.axesOffsetCB_ = PanCheckBox.createSmall("axes.offset", "Offset axes from grid edges", this.pmeta_.getBoolean("axes.offset"));
        PanLabel aWeightLabel = PanLabel.createSmall("Tickmark Weight: ");
        this.tickWeightSpinner_ = PanIntSpinner.createSmallWeight("axes.tickmark.weight", this.pmeta_.getInt("axes.tickmark.weight"), 200);
        PanLabel aPctLabel = PanLabel.createSmall("%");
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        QuickBox gStyleBox = QuickBox.createCenterBox(gStyleLabel, this.gridStyleCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel, Box.createHorizontalStrut(30), PanLabel.createSmall(" \u2014 "), Box.createHorizontalStrut(30), this.axesOffsetCB_, Box.createHorizontalStrut(30), PanLabel.createSmall(" \u2014 "), Box.createHorizontalStrut(30), aWeightLabel, this.tickWeightSpinner_, aPctLabel);
        PanCommonXAxisControls xaxisCtrls = new PanCommonXAxisControls(this.pmeta_, this.mbar_);
        PanLabel s1Label = PanLabel.createSmall("Stroke: ");
        PanLabel s1StyleLabel = PanLabel.createSmall("Style: ");
        this.s1StyleCombo_ = PanEnumComboBox.createSmall(PanParameterKeys.STROKE_STYLE[0], PanStrokeStyle.class);
        this.s1StyleCombo_.removeItem(PanStrokeStyle.NONE);
        this.s1StyleCombo_.setSelectedItem(this.pmeta_.getString(PanParameterKeys.STROKE_STYLE[0]));
        QuickBox s1StrokeBox = QuickBox.createLeftBox(s1Label, s1StyleLabel, this.s1StyleCombo_);
        PanLabel gapLabel22 = PanLabel.createSmall("  ");
        PanLabel colorLabel = PanLabel.createSmall("Color: ");
        this.s1ColorCombo_ = PanColorComboBox.createSmallRainbow(PanParameterKeys.STROKE_COLOR[0]);
        this.s1ColorCombo_.setSelectedColor(this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[0]));
        PanLabel strokeWeightLabel = PanLabel.createSmall(", Weight: ");
        this.s1WeightSpinner_ = PanIntSpinner.createSmallWeightX5(PanParameterKeys.STROKE_WEIGHT[0], this.pmeta_.getInt(PanParameterKeys.STROKE_WEIGHT[0]), 500);
        QuickBox s1ColorBox = QuickBox.createLeftBox(gapLabel22, colorLabel, this.s1ColorCombo_, strokeWeightLabel, this.s1WeightSpinner_);
        PanLabel gapLabel23 = PanLabel.createSmall("  ");
        PanLabel s1CapLabel = PanLabel.createSmall("Caption: ");
        this.dfltS1CapButton_ = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[0], "Default", !this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0]));
        this.userS1CapButton_ = PanRadioButton.createSmall(PanParameterKeys.STROKE_LABEL_CUSTOM[0], "Other:", this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0]));
        ButtonGroup s1CapChoices = new ButtonGroup();
        s1CapChoices.add(this.dfltS1CapButton_);
        s1CapChoices.add(this.userS1CapButton_);
        this.s1CaptionTF_ = PanTextField.createSmall(PanParameterKeys.STROKE_LABEL_TEXT[0], this.pmeta_.getString(PanParameterKeys.STROKE_LABEL_TEXT[0]), 20);
        QuickBox s1CaptionBox = QuickBox.createLeftBox(gapLabel23, s1CapLabel, this.dfltS1CapButton_, this.userS1CapButton_, this.s1CaptionTF_);
        GuiUtils.matchLabelWidths(s1Label, gapLabel22, gapLabel23);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 6, 0, 2);
        fgl.setRigidWidth(true);
        fgl.setRowWeight(5, 9999.0f);
        this.setLayout(fgl);
        this.setBorder(PanGuiConstants.STD_BORDER);
        this.add((Component)gStyleBox, new FGConstraint(0, 0, 2, 1, -1.0, 0.0));
        this.add((Component)new JSeparator(), new FGConstraint(0, 1, 2, 1));
        this.add((Component)xaxisCtrls, new FGConstraint(0, 2, 1, 4));
        this.add((Component)s1StrokeBox, new FGConstraint(1, 2));
        this.add((Component)s1ColorBox, new FGConstraint(1, 3));
        this.add((Component)s1CaptionBox, new FGConstraint(1, 4));
    }

    private final void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getStringValue());
        });
        this.gridWeightSpinner_.addChangeListener(e -> this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue()));
        this.axesOffsetCB_.addItemListener(e -> {
            boolean checked = this.axesOffsetCB_.isSelected();
            this.pmeta_.setBoolean("axes.offset", checked);
            this.tickWeightSpinner_.setEnabled(!checked);
        });
        this.tickWeightSpinner_.addChangeListener(e -> this.pmeta_.setInt("axes.tickmark.weight", this.tickWeightSpinner_.getIntValue()));
        this.s1StyleCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.set(PanParameterKeys.STROKE_STYLE[0], this.s1StyleCombo_.getStringValue());
        });
        this.s1ColorCombo_.addItemListener(e -> {
            Color cold;
            if (e.getStateChange() != 1) {
                return;
            }
            int index = this.s1ColorCombo_.getSelectedIndex();
            if (index < 0 || index >= this.s1ColorCombo_.getItemCount()) {
                return;
            }
            Color cnew = this.s1ColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor(PanParameterKeys.STROKE_COLOR[0]))) {
                this.pmeta_.setColor(PanParameterKeys.STROKE_COLOR[0], cnew);
            }
        });
        this.s1WeightSpinner_.addChangeListener(e -> this.pmeta_.setInt(PanParameterKeys.STROKE_WEIGHT[0], this.s1WeightSpinner_.getIntValue()));
        this.dfltS1CapButton_.addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], this.userS1CapButton_.isSelected()));
        this.userS1CapButton_.addActionListener(e -> this.pmeta_.setBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0], this.userS1CapButton_.isSelected()));
        this.s1CaptionTF_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PanLonLatZonalControls.this.s1CaptionTF_ == null || PanLonLatZonalControls.this.pmeta_ == null) {
                    return;
                }
                PanLonLatZonalControls.this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], PanLonLatZonalControls.this.s1CaptionTF_.getText());
            }
        });
        this.s1CaptionTF_.addActionListener(e -> this.pmeta_.setString(PanParameterKeys.STROKE_LABEL_TEXT[0], this.s1CaptionTF_.getText()));
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("grid.style")) {
            this.gridStyleCombo_.setSelectedItem(this.pmeta_.getString("grid.style"));
        }
        if (changeAll || pname.contains("grid.weight")) {
            this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        }
        this.repaint();
    }
}

