/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanScaleControls1D
extends PanScaleControls {
    private PanButton swapButton_;
    private Action swapAction_;

    public PanScaleControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        if (!this.plotType_.isLinePlot()) {
            throw new IllegalArgumentException("Plot type is not line plot.");
        }
        this.createActions(mbar);
        this.createLayout();
    }

    @Override
    protected final void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuByName("plot-menu");
        plotMenu.getItemByName("log-scale").setEnabled(this.plotType_ == PanPlotType.HORZ_LINE);
        if (this.plotType_ == PanPlotType.HORZ_LINE) {
            this.swapAction_ = new SwapBoundsAction("swap-ybounds");
            this.pmeta_.putAction("swap-ybounds", this.swapAction_);
            plotMenu.getItemByName("swap-ybounds").setAction(this.swapAction_);
            plotMenu.getItemByName("swap-ybounds").setEnabled(true);
        } else {
            this.swapAction_ = new SwapBoundsAction("swap-xbounds");
            this.pmeta_.putAction("swap-xbounds", this.swapAction_);
            plotMenu.getItemByName("swap-xbounds").setAction(this.swapAction_);
            plotMenu.getItemByName("swap-xbounds").setEnabled(true);
        }
    }

    private final void createLayout() {
        PanLabel axLabel2;
        PanLabel axLabel1;
        PanLabel axLabel0;
        if (this.plotType_ == PanPlotType.HORZ_LINE) {
            axLabel0 = PanLabel.createSmall("Y Scale: ");
            axLabel1 = PanLabel.createSmall("Bottom: ");
            axLabel2 = PanLabel.createSmall(", Top: ");
            this.swapButton_ = PanButton.createSmall("swap-ybounds", this.swapAction_, "Swap B/T");
        } else {
            axLabel0 = PanLabel.createSmall("X Scale: ");
            axLabel1 = PanLabel.createSmall("Left: ");
            axLabel2 = PanLabel.createSmall(", Right: ");
            this.swapButton_ = PanButton.createSmall("swap-xbounds", this.swapAction_, "Swap L/R");
        }
        this.fitToDataButton_.setText("Reset");
        QuickBox rangeBox = QuickBox.createLeftBox(axLabel1, this.val1TF_, axLabel2, this.val2TF_, this.swapButton_, this.fitToDataButton_, Box.createVerticalStrut(12));
        PanLabel unitsLabel1 = PanLabel.createSmall("Units: ");
        PanLabel unitsLabel2 = PanLabel.createSmall("of ");
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_);
        PanLabel formatLabel1 = PanLabel.createSmall("Ticks: ");
        PanLabel formatLabel2 = PanLabel.createSmall("Format: ");
        PanLabel formatLabel3 = PanLabel.createSmall("\u2014 ");
        PanLabel formatLabel4 = PanLabel.createSmall("Divisions: Major: ");
        PanLabel formatLabel5 = PanLabel.createSmall(", Minor: ");
        PanLabel formatLabel6 = PanLabel.createSmall("\u2014 Size: ");
        PanLabel formLabel1 = PanLabel.createSmall("Format: ");
        QuickBox divBox = QuickBox.createLeftBox(formatLabel1, formatLabel2, this.tickFormatCombo_, formatLabel3, formatLabel4, this.majorDivSpinner_, formatLabel5, this.minorDivSpinner_, formatLabel6, this.tickSizeCombo_);
        PanLabel captionLabel1 = PanLabel.createSmall("Caption: ");
        PanLabel captionLabel2 = PanLabel.createSmall("\u2014 Size: ");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel1, this.dfltCaptionButton_, this.customCaptionButton_, this.captionTF_, captionLabel2, this.captionSizeCombo_);
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
        this.setOpaque(false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 4, 0, 2);
        fgl.setRigidHeight(true);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        this.setBorder(null);
        this.add((Component)axLabel0, new FGConstraint(0, 0));
        this.add((Component)rangeBox, new FGConstraint(1, 0));
        this.add((Component)unitsBox, new FGConstraint(1, 1));
        this.add((Component)divBox, new FGConstraint(1, 2));
        this.add((Component)captionBox, new FGConstraint(1, 3));
        GuiUtils.matchLabelWidths(formLabel1, unitsLabel1);
    }

    private final void swapExtrema() {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        String bstr = this.val2TF_.getText();
        String tstr = this.val1TF_.getText();
        this.val2TF_.setText(tstr);
        this.val1TF_.setText(bstr);
        this.pmeta_.setGroup({"scale.min", oldval2}, {"scale.max", oldval1});
    }

    @Override
    public void setScaleRange(double val1, double val2) {
        this.val1TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val1));
        this.val2TF_.setText(PrintfFormat.PFORMAT_7G.sprintg(val2));
        this.pmeta_.setGroup({"scale.min", val1}, {"scale.max", val2});
    }

    public void zoom(double factor) {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double center = 0.5 * (oldval1 + oldval2);
        double diff = oldval2 - oldval1;
        double newdiff = diff / factor;
        double halfdiff = 0.5 * newdiff;
        double newval1 = center - halfdiff;
        double newval2 = center + halfdiff;
        this.setScaleRange(newval1, newval2);
    }

    public void zoom(double factor, double center) {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double diff = oldval2 - oldval1;
        double newdiff = diff / factor;
        double halfdiff = 0.5 * newdiff;
        double newval1 = center - halfdiff;
        double newval2 = center + halfdiff;
        this.setScaleRange(newval1, newval2);
    }

    class SwapBoundsAction
    extends AbstractAction {
        private boolean busy_;

        SwapBoundsAction(String actionID) {
            super(PanProperties.MENU_PROPS.getString(actionID));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            PanScaleControls1D.this.swapExtrema();
            this.busy_ = false;
        }
    }
}

