/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.ui.PanStringComboBox;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import java.awt.Component;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLonLatPrefsPanel
extends PanAbstractPrefsPanel {
    private PanStringComboBox lonlatTypeCombo_;

    public PanLonLatPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel topText = PanLabel.create("When creating a lon-lat plot, set\u2026");
        this.lonlatTypeCombo_ = PanStringComboBox.create();
        this.lonlatTypeCombo_.addItem(PanProperties.MENU_PROPS.getString("plot-type-m1"));
        this.lonlatTypeCombo_.addItem(PanProperties.MENU_PROPS.getString("plot-type-z1"));
        QuickBox typeBox = QuickBox.createLeftBox(PanLabel.create("Plot Type: "), this.lonlatTypeCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 0, 2);
        this.setLayout(fgl);
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Plot Defaults"));
        this.add((Component)topText, new FGConstraint(0, 0, 1, 1));
        this.add((Component)typeBox, new FGConstraint(0, 1, 1, 1));
        this.lonlatTypeCombo_.setMaximumSize(this.lonlatTypeCombo_.getPreferredSize());
    }

    private final void attachListeners() {
        this.lonlatTypeCombo_.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.refreshing_) {
                return;
            }
            prefs_.set("plot:lonlat.lltype", this.lonlatTypeCombo_.getSelectedItem());
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.lonlatTypeCombo_.setSelectedItem(prefs_.getString("plot:lonlat.lltype"));
        this.refreshing_ = false;
    }
}

