/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanLabel;
import gov.nasa.giss.panoply.util.PanNetcdfUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.Box;
import javax.swing.BoxLayout;

public class PanUnitsPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox cIsCelsiusCB_;
    private PanCheckBox mbIsMillibarCB_;
    private PanCheckBox fractionIsPercentCB_;

    public PanUnitsPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private final void createLayout() {
        PanLabel topText = PanLabel.create("Allow for non-standard variable units strings\u2026");
        this.cIsCelsiusCB_ = PanCheckBox.create("Treat 'C' as meaning Celsius (not Coulomb)");
        this.mbIsMillibarCB_ = PanCheckBox.create("Treat 'mb' as meaning millibar");
        this.fractionIsPercentCB_ = PanCheckBox.create("Treat 'fraction' as meaning percent");
        PanLabel bText = PanLabel.createSmall("Changing unit options may have unpredictable effects on open plots.");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Units"));
        this.add(QuickBox.createLeftBox(topText));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.cIsCelsiusCB_));
        this.add(QuickBox.createLeftBox(this.mbIsMillibarCB_));
        this.add(QuickBox.createLeftBox(this.fractionIsPercentCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createCenterBox(bText));
    }

    private final void attachListeners() {
        this.cIsCelsiusCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.cIsCelsiusCB_.isSelected();
            prefs_.setBoolean("units:c_is_celsius", bb);
            PanNetcdfUtils.updateAltUnits();
        });
        this.mbIsMillibarCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.mbIsMillibarCB_.isSelected();
            prefs_.setBoolean("units:mb_is_millibar", bb);
            PanNetcdfUtils.updateAltUnits();
        });
        this.fractionIsPercentCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.fractionIsPercentCB_.isSelected();
            prefs_.setBoolean("units:fraction_is_percent", bb);
            PanNetcdfUtils.updateAltUnits();
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        this.refreshing_ = true;
        this.cIsCelsiusCB_.setSelected(prefs_.getBoolean("units:c_is_celsius"));
        this.mbIsMillibarCB_.setSelected(prefs_.getBoolean("units:mb_is_millibar"));
        this.refreshing_ = false;
    }
}

