/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanPlotSize;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PanDnVPopup
extends JPopupMenu {
    private final AbstractAction size080Action_;
    private final AbstractAction size100Action_;
    private final AbstractAction size120Action_;
    private final AbstractAction size140Action_;
    private final AbstractAction size160Action_;
    private final AbstractAction size180Action_;
    private final AbstractAction size200Action_;
    private final AbstractAction size240Action_;
    private final AbstractAction size300Action_;
    private final AbstractAction exportCdlAction_;
    private final AbstractAction exportCsvAction_;
    private final AbstractAction exportTextAction_;
    private final AbstractAction closeDatasetAction_;
    private final PanSourcesFrame parent_;

    public PanDnVPopup(PanSourcesFrame parent) {
        this.parent_ = parent;
        final PanActionHash actionHash = this.parent_.getActionHash();
        this.size080Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-080")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_080);
            }
        };
        this.add(new JMenuItem(this.size080Action_));
        this.size100Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-100")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_100);
            }
        };
        this.add(new JMenuItem(this.size100Action_));
        this.size120Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-120")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_120);
            }
        };
        this.add(new JMenuItem(this.size120Action_));
        this.size140Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-140")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_140);
            }
        };
        this.add(new JMenuItem(this.size140Action_));
        this.size160Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-160")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_160);
            }
        };
        this.add(new JMenuItem(this.size160Action_));
        this.size180Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-180")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_180);
            }
        };
        this.add(new JMenuItem(this.size180Action_));
        this.size200Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-200")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_200);
            }
        };
        this.add(new JMenuItem(this.size200Action_));
        this.size240Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-240")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_240);
            }
        };
        this.add(new JMenuItem(this.size240Action_));
        this.size300Action_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("size_300")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PanCreatePlotAction)actionHash.get("create-plot")).createPlot(PanPlotSize.SIZE_300);
            }
        };
        this.add(new JMenuItem(this.size300Action_));
        this.addSeparator();
        this.exportCdlAction_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("export-cdl")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("export-cdl")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportCdlAction_));
        this.exportCsvAction_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("export-csv")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("export-csv")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportCsvAction_));
        this.exportTextAction_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("export-text")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("export-text")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.exportTextAction_));
        this.addSeparator();
        this.closeDatasetAction_ = new AbstractAction(PanProperties.POPUP_PROPS.getString("remove-one")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Action)actionHash.get("remove-one")).actionPerformed(null);
            }
        };
        this.add(new JMenuItem(this.closeDatasetAction_));
    }

    void refresh(NcDataNode node) {
        this.size080Action_.setEnabled(false);
        this.size100Action_.setEnabled(false);
        this.size120Action_.setEnabled(false);
        this.size140Action_.setEnabled(false);
        this.size160Action_.setEnabled(false);
        this.size180Action_.setEnabled(false);
        this.size200Action_.setEnabled(false);
        this.size240Action_.setEnabled(false);
        this.size300Action_.setEnabled(false);
        this.exportCdlAction_.setEnabled(false);
        this.exportCsvAction_.setEnabled(false);
        this.exportTextAction_.setEnabled(false);
        this.closeDatasetAction_.setEnabled(false);
        if (node == null) {
            return;
        }
        if (node instanceof NcDataset) {
            this.exportCdlAction_.setEnabled(true);
            this.closeDatasetAction_.setEnabled(true);
            return;
        }
        if (!(node instanceof NcVariable)) {
            return;
        }
        this.exportCdlAction_.setEnabled(true);
        this.exportCsvAction_.setEnabled(true);
        this.exportTextAction_.setEnabled(true);
        NcVariable ncv = (NcVariable)node;
        if (ncv.isGriddable()) {
            this.size080Action_.setEnabled(true);
            this.size100Action_.setEnabled(true);
            this.size120Action_.setEnabled(true);
            this.size140Action_.setEnabled(true);
            this.size160Action_.setEnabled(true);
            this.size180Action_.setEnabled(true);
            this.size200Action_.setEnabled(true);
            this.size240Action_.setEnabled(true);
            this.size300Action_.setEnabled(true);
        }
    }
}

