/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.action.PanCombinePlotAction;
import gov.nasa.giss.panoply.action.PanCreatePlotAction;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanActionHash;
import gov.nasa.giss.panoply.util.PanPlotSize;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.Toolbar;
import gov.nasa.giss.ui.ToolbarButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class PanSourcesToolBar
extends Toolbar {
    private final PanSourcesFrame parent_;
    private final ImageIcon hideInfoIcon_;
    private final ImageIcon showInfoIcon_;
    private final ToolbarButton createPlotButton_;
    private final ToolbarButton combinePlotButton_;
    private final ToolbarButton openDatasetButton_;
    private final ToolbarButton removeOneButton_;
    private final ToolbarButton removeAllButton_;
    private final ToolbarButton toggleInfoButton_;
    private final int lprefIconWidth_;
    private final int rprefIconWidth_;

    public PanSourcesToolBar(PanSourcesFrame parent) {
        this.parent_ = parent;
        this.setShowBottomEdge(false);
        PanActionHash actionHash = this.parent_.getActionHash();
        ImageIcon createPlotIcon = new ImageIcon(this.getClass().getResource("resources/createplot.png"));
        ImageIcon combinePlotIcon = new ImageIcon(this.getClass().getResource("resources/combineplot.png"));
        ImageIcon openDatasetIcon = new ImageIcon(this.getClass().getResource("resources/opendataset.png"));
        this.hideInfoIcon_ = new ImageIcon(this.getClass().getResource("resources/hideinfo.png"));
        this.showInfoIcon_ = new ImageIcon(this.getClass().getResource("resources/showinfo.png"));
        ImageIcon removeOneIcon = new ImageIcon(this.getClass().getResource("resources/clear.png"));
        ImageIcon removeAllIcon = new ImageIcon(this.getClass().getResource("resources/clearall.png"));
        this.createPlotButton_ = new ToolbarButton(createPlotIcon, PanProperties.SOURCES_PROPS.getString("create-plot"), (Action)actionHash.get("create-plot"), PanProperties.SOURCES_PROPS.getString("create-plot-tip"));
        this.combinePlotButton_ = new ToolbarButton(combinePlotIcon, PanProperties.SOURCES_PROPS.getString("combine-plot"), (Action)actionHash.get("combine-plot"), PanProperties.SOURCES_PROPS.getString("combine-plot-tip"));
        this.openDatasetButton_ = new ToolbarButton(openDatasetIcon, PanProperties.SOURCES_PROPS.getString("open-catalog-data"), (Action)actionHash.get("open-catalog-data"), PanProperties.SOURCES_PROPS.getString("open-dataset-tip"));
        this.toggleInfoButton_ = new ToolbarButton(this.hideInfoIcon_, PanProperties.SOURCES_PROPS.getString("toggle-info"), (Action)actionHash.get("toggle-info"), PanProperties.SOURCES_PROPS.getString("toggle-info-tip"));
        this.removeOneButton_ = new ToolbarButton(removeOneIcon, PanProperties.SOURCES_PROPS.getString("remove-one"), (Action)actionHash.get("remove-one"), PanProperties.SOURCES_PROPS.getString("remove-one-tip"));
        this.removeAllButton_ = new ToolbarButton(removeAllIcon, PanProperties.SOURCES_PROPS.getString("remove-all"), (Action)actionHash.get("remove-all"), PanProperties.SOURCES_PROPS.getString("remove-all-tip"));
        this.add(this.createPlotButton_);
        this.add(this.combinePlotButton_);
        this.add(this.openDatasetButton_);
        this.add(Box.createHorizontalGlue());
        this.add(this.removeOneButton_);
        this.add(this.removeAllButton_);
        this.add(this.toggleInfoButton_);
        this.lprefIconWidth_ = MathUtils.max(this.createPlotButton_.getPreferredSize().width, this.combinePlotButton_.getPreferredSize().width, this.openDatasetButton_.getPreferredSize().width) + 4;
        this.rprefIconWidth_ = MathUtils.max(this.removeOneButton_.getPreferredSize().width, this.removeAllButton_.getPreferredSize().width, this.toggleInfoButton_.getPreferredSize().width) + 4;
        this.refresh();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 2000;
        return d;
    }

    public final void refresh() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (prefs.getBoolean("sources:toolbar.labels")) {
            this.createPlotButton_.setText(PanProperties.SOURCES_PROPS.getString("create-plot"));
            this.combinePlotButton_.setText(PanProperties.SOURCES_PROPS.getString("combine-plot"));
            this.openDatasetButton_.setText(PanProperties.SOURCES_PROPS.getString("open-catalog-data"));
            this.removeOneButton_.setText(PanProperties.SOURCES_PROPS.getString("remove-one"));
            this.removeAllButton_.setText(PanProperties.SOURCES_PROPS.getString("remove-all"));
            if (prefs.getBoolean("sources:info.vis")) {
                this.toggleInfoButton_.setText(PanProperties.SOURCES_PROPS.getString("hide-info"));
            } else {
                this.toggleInfoButton_.setText(PanProperties.SOURCES_PROPS.getString("show-info"));
            }
        } else {
            this.openDatasetButton_.setText(null);
            this.createPlotButton_.setText(null);
            this.combinePlotButton_.setText(null);
            this.removeOneButton_.setText(null);
            this.removeAllButton_.setText(null);
            this.toggleInfoButton_.setText(null);
        }
        if (prefs.getBoolean("sources:info.vis")) {
            this.toggleInfoButton_.setIcon(this.hideInfoIcon_);
        } else {
            this.toggleInfoButton_.setIcon(this.showInfoIcon_);
        }
        this.refreshCreatePlotButton();
        this.refreshCombinePlotButton();
        this.createPlotButton_.setPreferredSize(null);
        Dimension psize = this.createPlotButton_.getPreferredSize();
        psize.width = this.lprefIconWidth_;
        this.createPlotButton_.setPreferredSize(psize);
        this.combinePlotButton_.setPreferredSize(psize);
        this.openDatasetButton_.setPreferredSize(psize);
        this.createPlotButton_.setMaximumSize(psize);
        this.combinePlotButton_.setMaximumSize(psize);
        this.openDatasetButton_.setMaximumSize(psize);
        this.removeOneButton_.setPreferredSize(null);
        psize = this.removeOneButton_.getPreferredSize();
        psize.width = this.rprefIconWidth_;
        this.removeOneButton_.setPreferredSize(psize);
        this.removeAllButton_.setPreferredSize(psize);
        this.toggleInfoButton_.setPreferredSize(psize);
        this.removeOneButton_.setMaximumSize(psize);
        this.removeAllButton_.setMaximumSize(psize);
        this.toggleInfoButton_.setMaximumSize(psize);
    }

    private final void refreshCreatePlotButton() {
        PanActionHash actionHash = this.parent_.getActionHash();
        final PanCreatePlotAction a = (PanCreatePlotAction)actionHash.get("create-plot");
        boolean createEnabled = a.isEnabled();
        this.createPlotButton_.setEnabled(createEnabled);
        JPopupMenu popup = this.createPlotButton_.getComponentPopupMenu();
        if (popup != null) {
            popup.setEnabled(createEnabled);
            for (Component c : popup.getComponents()) {
                if (c == null) continue;
                c.setEnabled(createEnabled);
            }
            return;
        }
        popup = new JPopupMenu("Create Plot");
        this.createPlotButton_.setComponentPopupMenu(popup);
        popup.add(a);
        popup.addSeparator();
        AbstractAction size080Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-080")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_080);
            }
        };
        popup.add(size080Action);
        AbstractAction size100Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-100")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_100);
            }
        };
        popup.add(size100Action);
        AbstractAction size120Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-120")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_120);
            }
        };
        popup.add(size120Action);
        AbstractAction size140Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-140")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_140);
            }
        };
        popup.add(size140Action);
        AbstractAction size160Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-160")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_160);
            }
        };
        popup.add(size160Action);
        AbstractAction size180Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-180")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_180);
            }
        };
        popup.add(size180Action);
        AbstractAction size200Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-200")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_200);
            }
        };
        popup.add(size200Action);
        AbstractAction size240Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size-240")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_240);
            }
        };
        popup.add(size240Action);
        AbstractAction size300Action = new AbstractAction(PanProperties.POPUP_PROPS.getString("size_300")){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.createPlot(PanPlotSize.SIZE_300);
            }
        };
        popup.add(size300Action);
        size080Action.setEnabled(false);
        size100Action.setEnabled(false);
        size120Action.setEnabled(false);
        size140Action.setEnabled(false);
        size160Action.setEnabled(false);
        size180Action.setEnabled(false);
        size200Action.setEnabled(false);
        size240Action.setEnabled(false);
        size300Action.setEnabled(false);
    }

    private final void refreshCombinePlotButton() {
        PanActionHash actionHash = this.parent_.getActionHash();
        final PanCombinePlotAction a = (PanCombinePlotAction)actionHash.get("combine-plot");
        this.combinePlotButton_.setEnabled(a.isEnabled());
        if (!this.combinePlotButton_.isEnabled()) {
            return;
        }
        JPopupMenu popup = this.combinePlotButton_.getComponentPopupMenu();
        if (popup == null) {
            popup = new JPopupMenu("Combine Plot");
            this.combinePlotButton_.setComponentPopupMenu(popup);
        }
        popup.removeAll();
        final PanPlotFrame[] plotFrames = PanGuiUtils.getPlotFrames();
        int isize = plotFrames.length;
        for (int i = 0; i < isize; ++i) {
            final int ii = i;
            AbstractAction action = new AbstractAction("Combine in " + plotFrames[i].getTitle()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    a.addToExistingPlot(plotFrames[ii].getTitle());
                }
            };
            popup.add(action);
        }
    }
}

