/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.GuiUtils;
import javax.swing.Action;
import javax.swing.JButton;

public final class PanButton
extends JButton {
    private PanButton(PanGuiSize size, String name, Action action) {
        super(action);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.setSizeVariant(size, this);
    }

    private PanButton(PanGuiSize size, String name, String text) {
        super(text);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.setSizeVariant(size, this);
    }

    public static PanButton create(String name, Action action) {
        return new PanButton(PanGuiSize.REGULAR, name, action);
    }

    public static PanButton create(String name, String text) {
        return new PanButton(PanGuiSize.REGULAR, name, text);
    }

    public static PanButton createSmall(String name, Action action) {
        return new PanButton(PanGuiSize.SMALL, name, action);
    }

    public static PanButton createSmall(String name, Action action, String text) {
        PanButton pb = new PanButton(PanGuiSize.SMALL, name, action);
        pb.setText(text);
        return pb;
    }

    public static PanButton createSmall(Action action, String text) {
        PanButton pb = new PanButton(PanGuiSize.SMALL, null, action);
        pb.setText(text);
        return pb;
    }

    public static PanButton createSmall(String name, String text) {
        return new PanButton(PanGuiSize.SMALL, name, text);
    }

    public static PanButton createSmall(String text) {
        return new PanButton(PanGuiSize.SMALL, null, text);
    }

    public static PanButton createSegmented(String position, String name, Action action) {
        PanButton pb = PanButton.create(name, action);
        pb.putClientProperty("JButton.buttonType", "segmented");
        pb.putClientProperty("JButton.segmentPosition", position);
        GuiUtils.restrictSize(pb);
        return pb;
    }

    public static PanButton createSegmented(String position, String name, String text) {
        PanButton pb = PanButton.create(name, text);
        pb.putClientProperty("JButton.buttonType", "segmented");
        pb.putClientProperty("JButton.segmentPosition", position);
        GuiUtils.restrictSize(pb);
        return pb;
    }
}

