/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.prefs.PanFavoritesEvent;
import gov.nasa.giss.panoply.prefs.PanFavoritesListener;
import gov.nasa.giss.panoply.prefs.PanProjectionInfo;
import gov.nasa.giss.panoply.prefs.PanProjectionPrefs;
import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import javax.swing.JComboBox;

public final class PanProjectionComboBox
extends JComboBox<String>
implements PanFavoritesListener {
    private final boolean favesOnly_;
    private boolean refreshing_;

    private PanProjectionComboBox(PanGuiSize size, String name, boolean favesOnly) {
        this.favesOnly_ = favesOnly;
        this.refresh();
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        pprefs.addFavoritesListener(this);
    }

    public boolean isRefreshing() {
        return this.refreshing_;
    }

    public void refresh() {
        PanProjectionInfo[] piArray;
        this.refreshing_ = true;
        String oldName = (String)this.getSelectedItem();
        boolean oldFound = false;
        this.removeAllItems();
        PanProjectionPrefs pprefs = PanProjectionPrefs.getSharedInstance();
        for (PanProjectionInfo projInfo : piArray = pprefs.getInfoArray()) {
            if (this.favesOnly_ && !projInfo.isFavorite()) continue;
            String newItem = projInfo.getName();
            this.addItem(newItem);
            if (oldName == null || !newItem.equals(oldName)) continue;
            this.setSelectedItem(newItem);
            oldFound = true;
        }
        if (oldFound) {
            this.setSelectedItem(oldName);
            this.refreshing_ = false;
            return;
        }
        this.refreshing_ = false;
        this.setSelectedItem("Equirectangular");
    }

    public void setSelectedItemByName(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object o = this.getItemAt(i);
            if (o == null || !name.equalsIgnoreCase(o.toString())) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedItemByName("Equirectangular");
    }

    @Override
    public void statusChanged(PanFavoritesEvent e) {
        this.refresh();
    }

    public static PanProjectionComboBox create(String name, boolean favesOnly) {
        return new PanProjectionComboBox(PanGuiSize.REGULAR, name, favesOnly);
    }

    public static PanProjectionComboBox createSmall(String name, boolean favesOnly) {
        return new PanProjectionComboBox(PanGuiSize.SMALL, name, favesOnly);
    }
}

