/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiSize;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class PanStringComboBox
extends JComboBox<String> {
    private static final String[] NUMBER_PFORMATS = new String[]{"%f", "%E", "%G", "%.0f", "%.0E", "%.0G", "%.1f", "%.1E", "%.1G", "%.2f", "%.2E", "%.2G", "%.3f", "%.3E", "%.3G", "%.4f", "%.4E", "%.4G", "%.5f", "%.5E", "%.5G", "%.6f", "%.6E", "%.6G"};

    public PanStringComboBox(PanGuiSize size, String name) {
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public PanStringComboBox(PanGuiSize size, String name, String ... objects) {
        super(objects);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public PanStringComboBox(PanGuiSize size, String name, ComboBoxModel<String> model) {
        super(model);
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.applyComboBoxUI(size, this);
    }

    public String getSelectedString() {
        return this.getSelectedItem().toString();
    }

    public static PanStringComboBox create() {
        return new PanStringComboBox(PanGuiSize.REGULAR, null);
    }

    public static PanStringComboBox createSmall() {
        return new PanStringComboBox(PanGuiSize.SMALL, null);
    }

    public static PanStringComboBox createSmall(String name) {
        return new PanStringComboBox(PanGuiSize.SMALL, name);
    }

    public static PanStringComboBox createSmall(ComboBoxModel<String> model) {
        return new PanStringComboBox(PanGuiSize.SMALL, null, model);
    }

    public static PanStringComboBox createSmall(String name, String ... objects) {
        return new PanStringComboBox(PanGuiSize.SMALL, name, objects);
    }

    public static PanStringComboBox createNumberFormatCB(String name) {
        return new PanStringComboBox(PanGuiSize.REGULAR, name, NUMBER_PFORMATS);
    }

    public static PanStringComboBox createSmallNumberFormatCB(String name) {
        return new PanStringComboBox(PanGuiSize.SMALL, name, NUMBER_PFORMATS);
    }
}

