/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.util.DescribedItem;

public enum PanPlotType implements DescribedItem
{
    LAT_TIME("Latitude-Time", "lattime", NcAxisType.LAT, NcAxisType.TIME),
    LAT_VERT("Latitude-Vertical", "latvert", NcAxisType.LAT, NcAxisType.VERT),
    LON_LAT("Longitude-Latitude", "lonlat", NcAxisType.LON, NcAxisType.LAT),
    LON_TIME("Longitude-Time", "lontime", NcAxisType.LON, NcAxisType.TIME),
    LON_VERT("Longitude-Vertical", "lonvert", NcAxisType.LON, NcAxisType.VERT),
    TIME_LAT("Time-Latitude", "timelat", NcAxisType.TIME, NcAxisType.LAT),
    TIME_VERT("Time-Vertical", "timevert", NcAxisType.TIME, NcAxisType.VERT),
    LL_TRAJ("Trajectory Feature-Type", "lltraj", NcAxisType.LON, NcAxisType.LAT),
    GENERAL_2D("Generic 2D", "generic2d", NcAxisType.X, NcAxisType.Y),
    HORZ_LINE("X-Axis Line-Plot", "xlineplot", NcAxisType.X, null),
    VERT_LINE("Y-Axis Line-Plot", "ylineplot", NcAxisType.Y, null);

    private final String description_;
    private final String abbrev_;
    private final NcAxisType[] axes_;

    private PanPlotType(String description, String abbrev, NcAxisType ... axes) {
        this.description_ = description;
        this.abbrev_ = abbrev;
        this.axes_ = axes;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public String getAbbreviation() {
        return this.abbrev_;
    }

    public NcAxisType[] getAxes() {
        return this.axes_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.abbrev_.equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanPlotType matching(String s) {
        for (PanPlotType item : PanPlotType.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        return null;
    }

    public boolean isGeoreferenced() {
        return this != HORZ_LINE && this != VERT_LINE && this != GENERAL_2D;
    }

    public boolean isLonLatMap() {
        return this == LON_LAT || this == LL_TRAJ;
    }

    public boolean isColorFill() {
        return this != LL_TRAJ && this != HORZ_LINE && this != VERT_LINE;
    }

    public boolean supportsVectorPlots() {
        return this == LON_LAT || this == LAT_VERT || this == LON_VERT || this == GENERAL_2D;
    }

    public boolean is2D() {
        return this != HORZ_LINE && this != VERT_LINE;
    }

    public boolean isLinePlot() {
        return this == HORZ_LINE || this == VERT_LINE;
    }

    public boolean isFeatureType() {
        return this == LL_TRAJ;
    }
}

