/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanStrokeStyle implements DescribedItem
{
    NONE("None", null),
    SOLID("Solid", null),
    LONGDASHES("Long Dashes", 10.0f, 4.0f),
    SHORTDASHES("Short Dashes", 5.0f, 3.0f),
    MIXEDDASHES("Mixed Dashes", 10.0f, 3.0f, 5.0f, 3.0f),
    DOTS("Dots", 2.5f, 2.5f),
    DOTDASH("Dot-Dash", 5.0f, 2.5f, 2.5f, 2.5f);

    private final String description_;
    private final float[] dashPattern_;

    private PanStrokeStyle(String description, float ... dashPattern) {
        this.description_ = description;
        this.dashPattern_ = dashPattern;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public float[] getDashPattern() {
        if (this.dashPattern_ == null) {
            return null;
        }
        float[] pcopy = new float[this.dashPattern_.length];
        for (int i = 0; i < this.dashPattern_.length; ++i) {
            pcopy[i] = this.dashPattern_[i];
        }
        return pcopy;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanStrokeStyle matching(String s) {
        for (PanStrokeStyle item : PanStrokeStyle.values()) {
            if (!item.matches(s)) continue;
            return item;
        }
        return SHORTDASHES;
    }
}

