/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.prefs;

import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.text.StringUtils;
import java.awt.Color;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class PreferencesHash {
    protected static final Boolean TRUE = Boolean.TRUE;
    protected static final Boolean FALSE = Boolean.FALSE;
    private String name_ = "";
    private TreeMap<String, Object> phash_ = new TreeMap();

    protected PreferencesHash() {
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public Set<String> keySet() {
        return this.phash_.keySet();
    }

    public boolean containsKey(String key) {
        return this.phash_.containsKey(key);
    }

    public Object get(String key) {
        Objects.requireNonNull(key, "Property key cannot be null.");
        int divider = key.indexOf(58);
        if (divider < 0) {
            assert (this.containsKey(key));
            return this.phash_.get(key);
        }
        String key1 = key.substring(0, divider);
        String key2 = key.substring(divider + 1);
        String key3 = null;
        int seconddivider = key2.indexOf(58);
        if (seconddivider > -1) {
            key3 = key2.substring(seconddivider + 1);
            key2 = key2.substring(0, seconddivider);
        }
        if (key3 == null) {
            return this.getGroup(key1).get(key2);
        }
        return this.getGroup(key1).getGroup(key2).get(key3);
    }

    public PreferencesHash getGroup(String key) {
        Object o = this.get(key);
        if (!(o instanceof PreferencesHash)) {
            throw new IllegalArgumentException("Not a property group: " + key);
        }
        return (PreferencesHash)o;
    }

    public boolean getBoolean(String key) {
        Object o = this.get(key);
        if (!(o instanceof Boolean)) {
            throw new IllegalArgumentException("Not a boolean property: " + key);
        }
        try {
            return (Boolean)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a boolean property: " + key);
        }
    }

    public Color getColor(String key) {
        Object o = this.get(key);
        if (!(o instanceof Color)) {
            throw new IllegalArgumentException("Not a color property: " + key);
        }
        try {
            return (Color)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a color property: " + key);
        }
    }

    public double getDouble(String key) {
        Object o = this.get(key);
        if (!(o instanceof Double)) {
            throw new IllegalArgumentException("Not a double property: " + key);
        }
        try {
            return (Double)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a double property: " + key);
        }
    }

    public float getFloat(String key) {
        Object o = this.get(key);
        if (!(o instanceof Float)) {
            throw new IllegalArgumentException("Not a float property: " + key);
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a float property: " + key);
        }
    }

    public int getInt(String key) {
        Object o = this.get(key);
        if (!(o instanceof Integer)) {
            throw new IllegalArgumentException("Not an integer property: " + key);
        }
        try {
            return (Integer)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not an integer property: " + key);
        }
    }

    public String getString(String key) {
        Object o = this.get(key);
        try {
            return o.toString();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a string property: " + key);
        }
    }

    public void set(String key, Object value) {
        Objects.requireNonNull(key, "Property key cannot be null.");
        int divider = key.indexOf(58);
        if (divider < 0) {
            this.phash_.put(key, value);
            return;
        }
        String key1 = key.substring(0, divider);
        String key2 = key.substring(divider + 1);
        Object o = this.get(key1);
        if (o == null) {
            o = new PreferencesHash();
            ((PreferencesHash)o).setName(key1);
            this.phash_.put(key1, o);
        } else if (!(o instanceof PreferencesHash)) {
            throw new IllegalArgumentException("Not a property group: " + key1);
        }
        ((PreferencesHash)o).set(key2, value);
    }

    public void setGroup(String key, PreferencesHash group) {
        this.set(key, group);
    }

    public void setBoolean(String key, boolean bvalue) {
        this.set(key, bvalue);
    }

    public void setBoolean(String key, String svalue) {
        if (svalue == null || svalue.length() == 0) {
            this.setBoolean(key, false);
        } else if (svalue.equals(Character.valueOf('1')) || svalue.equals(Character.valueOf('T'))) {
            this.setBoolean(key, true);
        } else {
            this.setBoolean(key, Boolean.valueOf(svalue));
        }
    }

    public void setColor(String key, Color cvalue) {
        Objects.requireNonNull(key, "Property key cannot be null.");
        Object oldValue = this.get(key);
        if (!(oldValue instanceof Color)) {
            throw new IllegalArgumentException("Property " + key + " not a color.");
        }
        this.set(key, cvalue);
    }

    public void setColor(String key, String svalue) {
        Color c = null;
        try {
            c = ColorUtils.parseColor(svalue);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not create Color from " + svalue);
        }
        if (c == null) {
            throw new IllegalArgumentException("Could not create Color from " + svalue);
        }
        this.setColor(key, c);
    }

    protected static Color createColor(String s) {
        try {
            return ColorUtils.parseColor(s);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not create Color from " + s);
        }
    }

    public void setDouble(String key, double dvalue) {
        Object oldValue = this.get(key);
        if (oldValue == null) {
            throw new IllegalArgumentException("No property key " + key);
        }
        if (!(oldValue instanceof Double)) {
            throw new IllegalArgumentException("Property " + key + " not a double.");
        }
        this.set(key, new Double(dvalue));
    }

    public void setDouble(String key, String svalue) {
        try {
            this.setDouble(key, StringUtils.parseDouble(svalue));
        }
        catch (Exception exc) {
            System.err.printf("WARNING: Could not set pref %s using double %f%n", key, svalue);
        }
    }

    public void setFloat(String key, float fvalue) {
        Object oldValue = this.get(key);
        if (oldValue == null) {
            throw new IllegalArgumentException("No property key " + key);
        }
        if (!(oldValue instanceof Float)) {
            throw new IllegalArgumentException("Property " + key + " not a float.");
        }
        this.set(key, new Float(fvalue));
    }

    public void setFloat(String key, String svalue) {
        try {
            this.setFloat(key, (float)StringUtils.parseDouble(svalue));
        }
        catch (Exception exc) {
            System.err.printf("WARNING: Could not set pref %s using float %f%n", key, svalue);
        }
    }

    public void setInt(String key, int ivalue) {
        Object oldValue = this.get(key);
        if (oldValue == null) {
            throw new IllegalArgumentException("No property key " + key);
        }
        if (!(oldValue instanceof Integer)) {
            throw new IllegalArgumentException("Property " + key + " not an integer.");
        }
        this.set(key, new Integer(ivalue));
    }

    public void setInt(String key, String svalue) {
        try {
            this.setInt(key, new Integer(svalue));
        }
        catch (Exception exc) {
            System.err.printf("WARNING: Could not set pref %s using int %d%n", key, svalue);
        }
    }

    public void setString(String key, String svalue) {
        Object oldValue = this.get(key);
        if (oldValue == null) {
            throw new IllegalArgumentException("No property key " + key);
        }
        if (!(oldValue instanceof String)) {
            throw new IllegalArgumentException("Property " + key + " not a string.");
        }
        this.set(key, svalue);
    }
}

