/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.ClimateModelCalendar;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalendarUtils {
    private static final String GREGORIAN = "gregorian";
    private static final String GREGORIAN_A = "standard";
    private static final String GREGORIAN_B = "mixed";
    private static final String PRO_GREG = "proleptic_gregorian";
    private static final String JULIAN = "julian";
    private static final String NO_LEAP = "noleap";
    private static final String NO_LEAP_A = "no_leap";
    private static final String NO_LEAP_B = "common_year";
    private static final String NO_LEAP_C = "365_day";
    private static final String ALL_LEAP = "all_leap";
    private static final String ALL_LEAP_A = "366_day";
    private static final String TWELVE_30 = "360_day";
    private static final String TWELVE_30_A = "360";

    private CalendarUtils() {
    }

    public static Calendar getCalendar(String cname) throws ParseException {
        String lcname;
        switch (lcname = cname.toLowerCase()) {
            case "gregorian": 
            case "standard": 
            case "mixed": 
            case "proleptic_gregorian": 
            case "julian": {
                TimeZone gmt = TimeZone.getTimeZone("GMT");
                gmt.setRawOffset(0);
                GregorianCalendar cc = new GregorianCalendar();
                if (lcname.equals(PRO_GREG)) {
                    cc.setGregorianChange(new Date(Long.MIN_VALUE));
                } else if (lcname.equals(JULIAN)) {
                    cc.setGregorianChange(new Date(Long.MAX_VALUE));
                }
                cc.setTimeZone(gmt);
                return cc;
            }
            case "noleap": 
            case "no_leap": 
            case "common_year": 
            case "365_day": {
                return new ClimateModelCalendar(ClimateModelCalendar.CalendarType.NO_LEAP);
            }
            case "all_leap": 
            case "366_day": {
                return new ClimateModelCalendar(ClimateModelCalendar.CalendarType.ALL_LEAP);
            }
            case "360_day": 
            case "360": {
                return new ClimateModelCalendar(ClimateModelCalendar.CalendarType.TWELVE_30);
            }
        }
        throw new ParseException("Calendar name '" + cname + "' is a mystery to me.", -1);
    }
}

