/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class ClimateModelCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int BCE = 0;
    public static final int AD = 1;
    public static final int CE = 1;
    private static final int[] DAYS_IN_YEAR = new int[]{365, 366, 360};
    private static final int[] MONTHS_IN_YEAR = new int[]{12, 12, 12};
    private static final int[] EPOCH_START = new int[]{1721903, 1719934, 1731748};
    private static final int[][] MONTH_LENGTH = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30}};
    private static final int[][] MONTH_START_DOY = new int[][]{{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334}, {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335}, {0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330}};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final int[] MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1, 1, -1, 0, 0, 0, 0, 0, 0, -43200000, 0};
    private static final int[][] LEAST_MAX_VALUES = new int[][]{{1, 292269054, 11, 52, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000}, {1, 292269054, 11, 52, 4, 29, 366, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000}, {1, 292269054, 11, 52, 4, 30, 360, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000}};
    private static final int[][] MAX_VALUES = new int[][]{{1, 292278994, 11, 53, 6, 31, 365, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000}, {1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000}, {1, 292278994, 11, 53, 6, 30, 360, 7, 6, 1, 11, 23, 59, 59, 999, 43200000, 3600000}};
    private static final double JD_UNIX = 2440587.5;
    private int calendarID_;

    public ClimateModelCalendar() {
        this(CalendarType.NO_LEAP, TimeZone.getDefault(), Locale.getDefault());
    }

    public ClimateModelCalendar(CalendarType calendarType) {
        this(calendarType, TimeZone.getDefault(), Locale.getDefault());
    }

    public ClimateModelCalendar(TimeZone zone, Locale aLocale) {
        this(CalendarType.NO_LEAP, zone, aLocale);
    }

    public ClimateModelCalendar(CalendarType calendarType, TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        switch (calendarType) {
            case NO_LEAP: {
                this.calendarID_ = 0;
                break;
            }
            case ALL_LEAP: {
                this.calendarID_ = 1;
                break;
            }
            case TWELVE_30: {
                this.calendarID_ = 2;
            }
        }
        this.setTimeInMillis(System.currentTimeMillis());
    }

    @Override
    public void add(int field, int amount) {
        this.complete();
        if (amount == 0) {
            return;
        }
        if (field == 1) {
            int year = this.internalGet(1);
            if (this.internalGetEra() == 1) {
                if ((year += amount) > 0) {
                    this.set(1, year);
                } else {
                    this.set(1, 1 - year);
                    this.set(0, 0);
                }
            } else if ((year -= amount) > 0) {
                this.set(1, year);
            } else {
                this.set(1, 1 - year);
                this.set(0, 1);
            }
            this.pinDayOfMonth();
            return;
        }
        if (field == 2) {
            int month = this.internalGet(2) + amount;
            if (month >= 0) {
                this.set(1, this.internalGet(1) + month / 12);
                this.set(2, month % 12);
            } else {
                this.set(1, this.internalGet(1) + (month + 1) / 12 - 1);
                if ((month %= 12) < 0) {
                    month += 12;
                }
                this.set(2, 0 + month);
            }
            this.pinDayOfMonth();
            return;
        }
        if (field == 0) {
            int era = this.internalGetEra() + amount;
            if (era < 0) {
                era = 0;
            }
            if (era > 1) {
                era = 1;
            }
            this.set(0, era);
            return;
        }
        long delta = amount;
        switch (field) {
            case 3: 
            case 4: 
            case 8: {
                delta *= 604800000L;
                break;
            }
            case 9: {
                delta *= 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                delta *= 86400000L;
                break;
            }
            case 10: 
            case 11: {
                delta *= 3600000L;
                break;
            }
            case 12: {
                delta *= 60000L;
                break;
            }
            case 13: {
                delta *= 1000L;
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setTimeInMillis(this.getTimeInMillis() + delta);
    }

    private final void pinDayOfMonth() {
        int monthLen = this.monthLength(this.internalGet(2) - 0);
        int dom = this.internalGet(5);
        if (dom > monthLen) {
            this.set(5, monthLen);
        }
    }

    @Override
    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    @Override
    public void roll(int field, int amount) {
        if (amount == 0) {
            return;
        }
    }

    @Override
    protected void computeFields() {
        int year;
        long localMillis = this.time;
        double julianDayX = 2440587.5 + (double)localMillis * 1.1574074074074074E-8;
        long julianDay = (long)(julianDayX + 0.5);
        long epochDay = julianDay - (long)EPOCH_START[this.calendarID_];
        int rawYear = (int)((epochDay - 1L) / (long)DAYS_IN_YEAR[this.calendarID_]);
        int january1 = rawYear * DAYS_IN_YEAR[this.calendarID_] + 1;
        int dayOfYear = (int)(epochDay - (long)january1);
        int dayOfWeek = (int)(julianDay + 1L) % 7;
        int months = MONTHS_IN_YEAR[this.calendarID_];
        int month = 0;
        for (int i = 0; i < months; ++i) {
            if (i == months - 1) {
                month = i;
                break;
            }
            if (dayOfYear >= MONTH_START_DOY[this.calendarID_][i + 1]) continue;
            month = i;
            break;
        }
        int dayOfMonth = dayOfYear - MONTH_START_DOY[this.calendarID_][month] + 1;
        int era = 1;
        if ((year = ++rawYear) < 1) {
            era = 0;
            year = 1 - year;
        }
        this.set(0, era);
        this.set(1, year);
        this.set(2, month + 0);
        this.set(5, dayOfMonth);
        this.set(6, ++dayOfYear);
        this.set(7, dayOfWeek);
        this.set(3, 1);
        this.set(4, 1);
        this.set(8, 1);
        int millisInDay = (int)(localMillis % 86400000L);
        if (millisInDay < 0) {
            millisInDay = (int)((long)millisInDay + 86400000L);
        }
        this.set(14, millisInDay % 1000);
        this.set(13, (millisInDay /= 1000) % 60);
        this.set(12, (millisInDay /= 60) % 60);
        this.set(11, millisInDay /= 60);
        this.set(9, millisInDay / 12);
        this.set(10, millisInDay % 12);
        this.set(15, 0);
        this.set(16, 0);
    }

    @Override
    public void computeTime() {
        if (!this.isLenient()) {
            throw new IllegalArgumentException();
        }
        int era = this.internalGetEra();
        int year = this.internalGet(1);
        long jan1JulianDay = era == 0 ? (long)(EPOCH_START[this.calendarID_] - DAYS_IN_YEAR[this.calendarID_] * year) : (long)(EPOCH_START[this.calendarID_] + DAYS_IN_YEAR[this.calendarID_] * (year - 1));
        long julianDiff = jan1JulianDay - 2440587L;
        long millis = julianDiff * 86400000L;
        millis += (long)MONTH_START_DOY[this.calendarID_][this.internalGet(2) - 0] * 86400000L;
        millis += (long)(this.internalGet(5) - 1) * 86400000L;
        int millisInDay = 0;
        millisInDay += this.internalGet(11);
        millisInDay *= 60;
        millisInDay += this.internalGet(12);
        millisInDay *= 60;
        millisInDay += this.internalGet(13);
        millisInDay *= 1000;
        this.time = millis += (long)(millisInDay += this.internalGet(14));
    }

    private final int monthLength(int month) {
        return MONTH_LENGTH[this.calendarID_][month];
    }

    @Override
    public int getGreatestMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getLeastMaximum(int field) {
        return LEAST_MAX_VALUES[this.calendarID_][field];
    }

    @Override
    public int getMaximum(int field) {
        return MAX_VALUES[this.calendarID_][field];
    }

    @Override
    public int getMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getActualMinimum(int field) {
        return this.getMinimum(field);
    }

    @Override
    public int getActualMaximum(int field) {
        switch (field) {
            case 5: {
                return this.monthLength(this.get(2));
            }
            case 6: {
                return DAYS_IN_YEAR[this.calendarID_];
            }
            case 3: 
            case 4: 
            case 8: {
                return super.getActualMaximum(field);
            }
            case 1: {
                return 292275056;
            }
        }
        return this.getMaximum(field);
    }

    private final int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : 1;
    }

    static enum CalendarType {
        NO_LEAP,
        ALL_LEAP,
        TWELVE_30;

    }
}

