/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.text;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public final class StringUtils {
    public static float parseFloat(String fs) throws NumberFormatException {
        return (float)StringUtils.parseDouble(fs);
    }

    public static double parseDouble(String d) throws NumberFormatException {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        String groupSep = Character.toString(symbols.getGroupingSeparator());
        String dd = d.replaceAll("\\s", "");
        String ddd = dd.replaceAll("\\" + groupSep, "");
        if (ddd.length() == 0) {
            throw new NumberFormatException("String does not look like a numeric text value");
        }
        int eindex = ddd.toLowerCase().indexOf(101);
        if (eindex > -1) {
            int eindex0 = eindex++;
            if (eindex == 1 || eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            if (ddd.substring(eindex, eindex + 1).equals("+")) {
                ++eindex;
            }
            if (eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            double exponent = 0.0;
            try {
                exponent = Integer.parseInt(ddd.substring(eindex));
            }
            catch (Exception exc) {
                throw new NumberFormatException("Could not parse apparent exponent in " + ddd);
            }
            double base = StringUtils.parseDouble(ddd.substring(0, eindex0));
            double result = base * Math.pow(10.0, exponent);
            return result;
        }
        try {
            NumberFormat nfi = NumberFormat.getNumberInstance();
            return nfi.parse(dd).doubleValue();
        }
        catch (Exception exception) {
            try {
                return Double.parseDouble(ddd);
            }
            catch (Exception exception2) {
                throw new NumberFormatException("String does not look like a numeric text value");
            }
        }
    }

    private StringUtils() {
    }
}

