/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakParameters;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public abstract class GempakStationFileIOSP
extends AbstractIOServiceProvider {
    private static Logger log = LoggerFactory.getLogger(GempakStationFileIOSP.class);
    protected AbstractGempakStationFileReader gemreader;
    protected StringBuilder parseInfo = new StringBuilder();
    protected static final Number RMISS = Float.valueOf(-9999.0f);
    protected static final Number IMISS = -9999;
    protected static final Dimension DIM_LEN8 = new Dimension("len8", 8, true);
    protected static final Dimension DIM_LEN4 = new Dimension("len4", 4, true);
    protected static final Dimension DIM_LEN2 = new Dimension("len2", 2, true);
    protected static final String TIME_VAR = "time";
    protected static final String MISSING_VAR = "_isMissing";
    private static String[] stnVarNames = new String[]{"STID", "STNM", "SLAT", "SLON", "SELV", "STAT", "COUN", "STD2", "SPRI", "SWFO", "WFO2"};
    private static int[] stnVarSizes = new int[]{8, 4, 4, 4, 4, 2, 2, 4, 4, 4, 4};

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.gemreader = this.makeStationReader();
            return this.gemreader.init(raf, false);
        }
        catch (Exception ioe) {
            return false;
        }
    }

    protected abstract AbstractGempakStationFileReader makeStationReader();

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        if (this.gemreader == null) {
            this.gemreader = this.makeStationReader();
        }
        this.initTables();
        this.gemreader.init(raf, true);
        this.buildNCFile();
    }

    private void initTables() throws IOException {
        GempakParameters.addParameters("resources/nj22/tables/gempak/params.tbl");
    }

    @Override
    public String getDetailInfo() {
        Formatter ff = new Formatter();
        ff.format("%s", super.getDetailInfo());
        ff.format("%s", this.parseInfo);
        return ff.toString();
    }

    protected void buildNCFile() throws IOException {
        this.ncfile.empty();
        this.fillNCFile();
        this.addGlobalAttributes();
        this.ncfile.finish();
    }

    protected abstract void fillNCFile() throws IOException;

    protected Structure makeStructure(String partName, List<Dimension> dimensions, boolean includeMissing) {
        List<GempakParameter> params = this.gemreader.getParameters(partName);
        if (params == null) {
            return null;
        }
        Structure sVar = new Structure(this.ncfile, null, null, partName);
        sVar.setDimensions(dimensions);
        for (GempakParameter param : params) {
            sVar.addMemberVariable(this.makeParamVariable(param, null));
        }
        if (includeMissing) {
            sVar.addMemberVariable(this.makeMissingVariable());
        }
        return sVar;
    }

    protected Variable makeMissingVariable() {
        Variable var = new Variable(this.ncfile, null, null, MISSING_VAR);
        var.setDataType(DataType.BYTE);
        var.setDimensions((List<Dimension>)null);
        var.addAttribute(new Attribute("description", "missing flag - 1 means all params are missing"));
        var.addAttribute(new Attribute("missing_value", (byte)1));
        return var;
    }

    protected Variable makeParamVariable(GempakParameter param, List<Dimension> dims) {
        Variable var = new Variable(this.ncfile, null, null, param.getName());
        var.setDataType(DataType.FLOAT);
        var.setDimensions(dims);
        var.addAttribute(new Attribute("long_name", param.getDescription()));
        String units = param.getUnit();
        if (units != null && !units.equals("")) {
            var.addAttribute(new Attribute("units", units));
        }
        var.addAttribute(new Attribute("missing_value", RMISS));
        return var;
    }

    protected void addGlobalAttributes() {
        this.ncfile.addAttribute(null, new Attribute("Conventions", this.getConventions()));
        String fileType = "GEMPAK " + this.gemreader.getFileType();
        this.ncfile.addAttribute(null, new Attribute("file_format", fileType));
        this.ncfile.addAttribute(null, new Attribute("history", "Direct read of " + fileType + " into NetCDF-Java API"));
        this.ncfile.addAttribute(null, new Attribute("featureType", this.getCFFeatureType()));
    }

    public String getConventions() {
        return "GEMPAK/CDM";
    }

    public String getCFFeatureType() {
        return CF.FeatureType.point.toString();
    }

    protected int getStnVarSize(String name) {
        int size = -1;
        for (int i = 0; i < stnVarNames.length; ++i) {
            if (!name.equals(stnVarNames[i])) continue;
            size = stnVarSizes[i];
            break;
        }
        return size;
    }

    protected List<Variable> makeStationVars(List<GempakStation> stations, Dimension dim) {
        int numStations = stations.size();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        List<String> stnKeyNames = this.gemreader.getStationKeyNames();
        for (String varName : stnKeyNames) {
            Variable v = this.makeStationVariable(varName, dim);
            Attribute stIDAttr = new Attribute("standard_name", "station_id");
            if (varName.equals("STID")) {
                v.addAttribute(stIDAttr);
            }
            vars.add(v);
        }
        if (dim != null && numStations > 0) {
            for (Variable v : vars) {
                Array varArray;
                if (v.getDataType().equals((Object)DataType.CHAR)) {
                    int[] shape = v.getShape();
                    varArray = new ArrayChar.D2(shape[0], shape[1]);
                } else {
                    varArray = this.get1DArray(v.getDataType(), numStations);
                }
                assert (varArray != null);
                int index = 0;
                String varname = v.getFullName();
                for (GempakStation stn : stations) {
                    String test = "";
                    switch (varname) {
                        case "STID": {
                            test = stn.getName();
                            break;
                        }
                        case "STNM": {
                            ((ArrayInt.D1)varArray).set(index, stn.getSTNM());
                            break;
                        }
                        case "SLAT": {
                            ((ArrayFloat.D1)varArray).set(index, (float)stn.getLatitude());
                            break;
                        }
                        case "SLON": {
                            ((ArrayFloat.D1)varArray).set(index, (float)stn.getLongitude());
                            break;
                        }
                        case "SELV": {
                            ((ArrayFloat.D1)varArray).set(index, (float)stn.getAltitude());
                            break;
                        }
                        case "STAT": {
                            test = stn.getSTAT();
                            break;
                        }
                        case "COUN": {
                            test = stn.getCOUN();
                            break;
                        }
                        case "STD2": {
                            test = stn.getSTD2();
                            break;
                        }
                        case "SPRI": {
                            ((ArrayInt.D1)varArray).set(index, stn.getSPRI());
                            break;
                        }
                        case "SWFO": {
                            test = stn.getSWFO();
                            break;
                        }
                        case "WFO2": {
                            test = stn.getWFO2();
                        }
                    }
                    if (!test.equals("")) {
                        ((ArrayChar.D2)varArray).setString(index, test);
                    }
                    ++index;
                }
                v.setCachedData(varArray, false);
            }
        }
        return vars;
    }

    private Array get1DArray(DataType type, int len) {
        Array varArray = null;
        if (type.equals((Object)DataType.FLOAT)) {
            varArray = new ArrayFloat.D1(len);
        } else if (type.equals((Object)DataType.DOUBLE)) {
            varArray = new ArrayDouble.D1(len);
        } else if (type.equals((Object)DataType.INT)) {
            varArray = new ArrayInt.D1(len, false);
        }
        return varArray;
    }

    protected Variable makeStationVariable(String varname, Dimension firstDim) {
        String longName = varname;
        String unit = null;
        DataType type = DataType.CHAR;
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (firstDim != null) {
            dims.add(firstDim);
        }
        switch (varname) {
            case "STID": {
                longName = "Station identifier";
                dims.add(DIM_LEN8);
                break;
            }
            case "STNM": {
                longName = "WMO station id";
                type = DataType.INT;
                break;
            }
            case "SLAT": {
                longName = "latitude";
                unit = "degrees_north";
                type = DataType.FLOAT;
                attrs.add(new Attribute("standard_name", "latitude"));
                break;
            }
            case "SLON": {
                longName = "longitude";
                unit = "degrees_east";
                type = DataType.FLOAT;
                attrs.add(new Attribute("standard_name", "longitude"));
                break;
            }
            case "SELV": {
                longName = "altitude";
                unit = "meter";
                type = DataType.FLOAT;
                attrs.add(new Attribute("positive", "up"));
                attrs.add(new Attribute("standard_name", "station_altitude"));
                break;
            }
            case "STAT": {
                longName = "state or province";
                dims.add(DIM_LEN2);
                break;
            }
            case "COUN": {
                longName = "country code";
                dims.add(DIM_LEN2);
                break;
            }
            case "STD2": {
                longName = "Extended station id";
                dims.add(DIM_LEN4);
                break;
            }
            case "SPRI": {
                longName = "Station priority";
                type = DataType.INT;
                break;
            }
            case "SWFO": {
                longName = "WFO code";
                dims.add(DIM_LEN4);
                break;
            }
            case "WFO2": {
                longName = "Second WFO code";
                dims.add(DIM_LEN4);
            }
        }
        Variable v = new Variable(this.ncfile, null, null, varname);
        v.setDataType(type);
        v.addAttribute(new Attribute("long_name", longName));
        if (unit != null) {
            v.addAttribute(new Attribute("units", unit));
        }
        if (type.equals((Object)DataType.FLOAT)) {
            v.addAttribute(new Attribute("missing_value", RMISS));
        } else if (type.equals((Object)DataType.INT)) {
            v.addAttribute(new Attribute("missing_value", IMISS));
        }
        if (!attrs.isEmpty()) {
            for (Attribute attr : attrs) {
                v.addAttribute(attr);
            }
        }
        if (!dims.isEmpty()) {
            v.setDimensions(dims);
        } else {
            v.setDimensions((String)null);
        }
        return v;
    }
}

