/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import org.n52.operation.cropmodeling.CropData;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.PlantOrgan;
import org.n52.operation.cropmodeling.TemporalEnvironmentState;
import org.n52.operation.cropmodeling.Weather;

public class Crop {
    private PlantOrgan[] plantOrgan = new PlantOrgan[PlantOrgan.OrganName.values().length];
    private double relativeDevelopmentStage = 0.001;
    private double livingDryLeafMass;
    private CropData cropData;
    protected Crop previousCropState = null;

    public Crop(CropData data) {
        int i = 0;
        PlantOrgan.OrganName[] organNameArray = PlantOrgan.OrganName.values();
        int n = 0;
        int n2 = organNameArray.length;
        while (n < n2) {
            PlantOrgan.OrganName organ = organNameArray[n];
            this.plantOrgan[i++] = new PlantOrgan(organ);
            ++n;
        }
        this.cropData = data;
        this.relativeDevelopmentStage = 0.0;
        this.livingDryLeafMass = 0.0;
    }

    public void increaseDevelopmentStage(TemporalEnvironmentState state, double temperature) {
        double DRDS = Math.max(0.0, (temperature - this.cropData.getAttributeData("ThresholdTemperature")) / this.cropData.getAttributeData("HeatRequirement"));
        DRDS = DRDS * state.getTimeResolution() / 24.0;
        this.relativeDevelopmentStage = this.getPreviousCropState() != null ? Math.min(1.0, this.getPreviousCropState().getRelativeDevelopmentStage() + DRDS) : Math.min(1.0, DRDS);
    }

    public void calculateCropState(TemporalEnvironmentState currentState) {
        this.increaseDevelopmentStage(currentState, currentState.getCurrentWeather().getWeatherData(currentState.getTime()).getDailyAverageTemperature());
        double Fgc = this.getCO2ReductionReferenceCrop(currentState);
        double WaterAvailability = this.getWaterAvailability(currentState);
        double FGass = Fgc * 30.0 / 44.0 * WaterAvailability;
        PlantOrgan[] plantOrganArray = this.plantOrgan;
        int n = 0;
        int n2 = plantOrganArray.length;
        while (n < n2) {
            PlantOrgan organ = plantOrganArray[n];
            double grossAssimilateDevelopment = FGass * this.cropData.getAllocatedMassFraction(organ.getType().ordinal(), this.relativeDevelopmentStage);
            double maintenanceRespirationRef = this.cropData.getIndexedAttribute("MaintenanceRespiration", organ.getType().ordinal()) * organ.getDryMass();
            double increaseDryOrganMass = (grossAssimilateDevelopment - maintenanceRespirationRef) * this.cropData.getIndexedAttribute("ConversionEfficiency", organ.getType().ordinal()) * 1.0;
            organ.setDryMass(this.getPreviousCropState().getOrgan(organ.getType()).getDryMass() + increaseDryOrganMass);
            if (organ.getType() == PlantOrgan.OrganName.Leaves) {
                this.livingDryLeafMass = this.relativeDevelopmentStage > this.cropData.getAttributeData("HeatRequirementLeaves") / this.cropData.getAttributeData("HeatRequirement") ? organ.getDryMass() - this.getPreviousCropState().getOrgan(PlantOrgan.OrganName.Leaves).getDryMass() : organ.getDryMass();
            }
            ++n;
        }
    }

    private double getWaterAvailability(TemporalEnvironmentState CurrentState) {
        return 1.0;
    }

    double getMaximumAssimilationRate(TemporalEnvironmentState currentState, double temperature) {
        return Double.NaN;
    }

    double getMaximumAssimilationRate(double referenceTemperature, double currentTemp) {
        return Double.NaN;
    }

    public double getCO2ReductionReferenceCrop(TemporalEnvironmentState currentState) {
        double temp = currentState.getCurrentWeather().getCurrentTemperature(currentState.getTime());
        double AMax = this.getMaximumAssimilationRate(currentState, temp);
        double Eff = 0.5;
        double extinctionCoefficient = this.cropData.getAttributeData("ExtinctionCoefficient");
        double CC = Eff * extinctionCoefficient * currentState.getCurrentRadiations().getPhotoSynthActiveCanopy();
        double teller = AMax + CC;
        double noemer = AMax + CC * Math.exp(-1.0 * this.getLeafAreaIndex() * extinctionCoefficient);
        if (noemer < 1.0E-7 || teller / noemer < 1.0E-7) {
            return 0.0;
        }
        double lg = Math.log(teller / noemer);
        double Fgc = currentState.getTime().getDayLength() * (AMax / extinctionCoefficient) * lg;
        return Fgc;
    }

    public double getLeafAreaIndex() {
        if (this.relativeDevelopmentStage == 0.0) {
            return 0.0;
        }
        double Sla = this.cropData.getAttributeData("MinSpecificLeafArea") - (this.cropData.getAttributeData("MaxSpecificLeafArea") - this.cropData.getAttributeData("MinSpecificLeafArea")) * Math.log(this.relativeDevelopmentStage);
        if (Sla > this.cropData.getAttributeData("MinSpecificLeafArea")) {
            Sla = this.cropData.getAttributeData("MinSpecificLeafArea");
        }
        double Lai = this.livingDryLeafMass * Sla * 1.0E-4;
        return Lai;
    }

    public PlantOrgan getOrgan(PlantOrgan.OrganName name) {
        return this.plantOrgan[name.ordinal()];
    }

    boolean isC3Plant() {
        return this.plantIsC3Type();
    }

    public boolean plantIsC3Type() {
        return true;
    }

    double getLivingDryLeafMass() {
        return this.livingDryLeafMass;
    }

    public double getTotalDryMass() {
        double totalLMass = 0.0;
        PlantOrgan[] plantOrganArray = this.plantOrgan;
        int n = 0;
        int n2 = plantOrganArray.length;
        while (n < n2) {
            PlantOrgan organ = plantOrganArray[n];
            totalLMass += organ.getDryMass();
            ++n;
        }
        return totalLMass;
    }

    double getRelativeDevelopmentStage() {
        return this.relativeDevelopmentStage;
    }

    double getTotalLivingDryMass() {
        return 8.0;
    }

    public CropData getFixedData() {
        return this.cropData;
    }

    public Crop getPreviousCropState() {
        return this.previousCropState;
    }

    public void setPreviousCropState(Crop myPreviousCropState) {
        this.previousCropState = myPreviousCropState;
    }

    double getTotalGrossAssimilation(TemporalEnvironmentState currentState) {
        double[] xGauss = new double[]{0.1127, 0.5, 0.8873};
        double[] wGauss = new double[]{0.2778, 0.444, 0.2778};
        int i = 0;
        while (i < 3) {
            double d = 12.0 + currentState.getTime().getDayLength() * 0.5 * xGauss[i];
            ++i;
        }
        return 0.0;
    }

    void assim(double hour, JulianTime time, Weather weather, double[] result) {
        double kdif = 0.7;
        double conc = 0.0;
        double fgross = 0.0;
        double opnam = 0.0;
        double[] xGauss = new double[]{0.1127, 0.5, 0.8873};
        double[] wGauss = new double[]{0.2778, 0.444, 0.2778};
        double scv = 0.2;
        double sinB = Math.max(0.0, time.getSSin() + time.getCCos() * (Math.PI * 2 * (hour + 12.0)));
        double refh = (1.0 - Math.sqrt(1.0 - scv)) / (1.0 + Math.sqrt(1.0 - scv));
        double refs = refh * 2.0 / (1.0 + 1.6 * sinB);
        double kdirbl = 0.5 / sinB * kdif / (0.8 * Math.sqrt(1.0 - scv));
        double kdirt = kdirbl * Math.sqrt(1.0 - scv);
        double dailyDirectRad = weather.getDailyDirectRadiation(time);
        double dailyDiffuseRad = weather.getDailyDiffuseRadiation(time);
        double[] res = new double[2];
        int i = 0;
        while (i < 3) {
            double rbs;
            double rss;
            double aMaxs;
            double fgrsh;
            double laic = this.getLeafAreaIndex() * xGauss[i];
            double visdf = (1.0 - refs) * dailyDiffuseRad * kdif * Math.exp(-kdif * laic);
            double vist = (1.0 - refs) * dailyDirectRad * kdirt * Math.exp(-kdirt * laic);
            double visd = (1.0 - scv) * dailyDirectRad * kdirbl * Math.exp(-kdirbl * laic);
            double vishd = visdf + vist - visd;
            double aMax = this.getMaximumAssimilationRate(weather.getReferenceTemperature(time), weather.getCurrentTemperature(time));
            double eff = 0.45;
            double opn = 0.0;
            double fgrsh1 = fgrsh = aMax * (1.0 - Math.exp(-vishd * eff / aMax));
            do {
                fgrsh = (fgrsh + fgrsh1) / 2.0;
                this.resist(0.0, 0.0, laic, 0.0, 0.0, res);
            } while (Math.abs((fgrsh1 = (aMaxs = Math.max(2.0, aMax * (1.0 - 0.23 * (opn = conc / ((rss = res[0]) + (rbs = res[1])))))) * (1.0 - Math.exp(vishd * eff / aMaxs))) - fgrsh) > 0.001);
            double opnsh = opn * 1.0E-5 * 3600.0;
            double vispp = (1.0 - scv) * dailyDirectRad / sinB;
            double fgrsun = 0.0;
            double opsun = 0.0;
            int j = 0;
            while (j < 3) {
                double fgrs;
                double vissun = vishd + vispp * xGauss[j];
                double fgrs1 = fgrs = aMax * (1.0 - Math.exp(-vissun * eff / aMax));
                do {
                    fgrs = (fgrs + fgrs1) / 2.0;
                    this.resist(0.0, 0.0, 0.0, 0.0, 0.0, res);
                    rss = res[0];
                    rbs = res[1];
                    opn = conc / (rss + rbs);
                    double aMaxs2 = Math.max(2.0, aMax * (1.0 - 0.23 * opn));
                    fgrsh1 = aMaxs2 * (1.0 - Math.exp(-vissun * eff / aMaxs2));
                } while (Math.abs(fgrs - fgrs1) > 0.001);
                double opsu = opn * 1.0E-5 * 3600.0;
                fgrsun += fgrs * wGauss[j];
                opsun += opsu * wGauss[j];
                ++j;
            }
            double fslla = Math.exp(-kdirbl * laic);
            double fgl = fslla * fgrsun + (1.0 - fslla) * fgrsh;
            double opna = fslla * opsun + (1.0 - fslla) * opnsh;
            fgross += fgl * wGauss[i];
            opnam = opna + opnam * wGauss[i];
            ++i;
        }
        result[0] = fgross *= this.getLeafAreaIndex();
        result[1] = opnam *= this.getLeafAreaIndex();
    }

    void resist(double wdsa, double laic, double assim, double amax, double co2, double[] result) {
        result[0] = 0.0;
        result[1] = 0.0;
    }
}

