@echo off
echo Import routine for the Copernicus Soil Water Index product
echo Use is made of the Ethiopia 1km Lat-Lon projection
echo Only yearmonthday timestamp is required
echo Temporal resolution is once per day 
echo File name format g2_BIOPAR_SWI_201401090000_GLOBE_ASCAT_V2.0.0.zip
echo Data available till 20160111
echo For more recent data select the Africa or South America import routines
echo.
echo.



set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set Infraview=%9


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo your current time stamp = %shortfilename1%
echo.
echo.


echo off
if not exist "%InputDrive%\%InputDir%\g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.zip"  goto MESSAGE
echo The file g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.zip is transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the source folder specified
echo Your source folder specified is %InputDrive%\%InputDir%
echo The input file was not found.
echo Check your directory and date stamp settings
echo.
echo Your source folder specified is %InputDrive%\%InputDir%
echo Your current date stamp used is %shortfilename1%
echo Check also manually if the data exists on your input directory - archive 
echo Note the temporal resolution of your data is once a day


pause

GOTO END

:START

rem Import SWI to ilwis

copy "%InputDrive%\%InputDir%\g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.zip"

"%UtilDir%\7z.exe" e "%OutputDrive%\%OutputDir%\g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.zip"

"%UtilDir%\7z.exe" e "%OutputDrive%\%OutputDir%\g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5.bz2"

rem swi_001

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_001 temp_SWI_001.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_001_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_001 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_001/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_001_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_005

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_005 temp_SWI_005.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_005_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_005 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_005/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_005_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_010

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_010 temp_SWI_010.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_010_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_010 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_010/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_010_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_015

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_015 temp_SWI_015.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_015_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_015 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_015/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_015_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_020

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_020 temp_SWI_020.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_020_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_020 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_020/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_020_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_040

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_040 temp_SWI_040.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_040_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_040 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_040/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_040_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_060

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_060 temp_SWI_060.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_060_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_060 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_060/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_060_%shortfilename1%.mpr %UtilDir%\SWI;

rem swi_100

"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"g2_BIOPAR_SWI_%shortfilename1%0000_GLOBE_ASCAT_V2.0.0.h5"://SWI/SWI_100 temp_SWI_100.mpr
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\SWI_100_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\temp_SWI_100 lt 255,%OutputDrive%\%OutputDir%\temp_SWI_100/2,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\SWI_100_%shortfilename1%.mpr %UtilDir%\SWI;


rem create maplist of 8 swi maps

copy "%IlwDir%\Extensions\Geonetcast-Toolbox\util\mpl_substitutename.bat"
copy "%IlwDir%\Extensions\Geonetcast-Toolbox\util\swi_.mpl"

cmd /c mpl_substitutename.bat ____ _%shortfilename1% swi_.mpl > swi_%shortfilename1%.mpl



del "%OutputDrive%\%OutputDir%\temp_SWI*.*"
del "%OutputDrive%\%OutputDir%\g2_BIOPAR_*"
del "%OutputDrive%\%OutputDir%\swi_.mpl"
del "%OutputDrive%\%OutputDir%\mpl_substitutename.bat"

:END
"%IlwDir%\ilwis.exe" -C closeall