@Echo off
rem import GOES 16 GLM from geonetcast
rem file name convention OR_GLM-L2-LCFA_G16_s20200872255000_e20200872300000_c2020087230323.tgz
rem the tgz file contains tar file
rem tar file containes 15 nc files, each file 20 seconds
rem following parameters are extracted from each nc file and concatenated into table over the time interval of 5 minutes
rem flash_id, flash_lat and flash_lon
rem temporal resolution is 5 minutes

echo off


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set shortfilename2=%shortfilename1:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDrive%\%OutputDir%*
echo *%shortfilename1%*
echo *%shortfilename2%*

:manualDATE
rem get date from interface - user as longfilename
set ldt=%longfilename:~0,8%


SETLOCAL

set yy=%ldt:~0,4%
set mm=%ldt:~4,2%
set dd=%ldt:~6,2%

set /a "yy=10000%yy% %%10000,mm=100%mm% %% 100,dd=100%dd% %% 100"
set /a JD=dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4
set /a "yy=10000%yy% %%10000,mm=1,dd=1"
set /a JD-=-1+dd-32075+1461*(yy+4800+(mm-14)/12)/4+367*(mm-2-(mm-14)/12*12)/12-3*((yy+4900+(mm-14)/12)/100)/4




if %JD% LEQ 9 (
set JD=00%JD%
)

rem echo %JD%

IF %JD% GEQ 10 (
	IF %JD% LSS 100 (
	set JD=0%JD%)
)

rem echo %JD%

if %JD% GEQ 100 (
set JD=%JD%
)

set full_doy=%ldt:~0,4%%JD%
echo day of year string and time (hhmm) used: %full_doy%%shortfilename2%
echo calculated DoY: %JD%
echo Current entered date [yyyymmdd]: %ldt%

echo.

echo.

echo processing GOES-16 Global Ligthing Imager 
echo.
copy "%InputDrive%\%InputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tgz"

if not exist "%OutputDrive%\%OutputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tgz" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tgz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1% and Day of Year settings %full_doy%%shortfilename2%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
echo.

"%UtilDir%\7z" e "%OutputDrive%\%OutputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tgz"
"%UtilDir%\7z" e "%OutputDrive%\%OutputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tar"

rem set environment variables

echo set longfilename=%1>inputparam.bat
echo set InputDrive=%2>>inputparam.bat
echo set InputDir=%3>>inputparam.bat
echo set OutputDrive=%4>>inputparam.bat
echo set OutputDir=%5>>inputparam.bat
echo set gdalDir=%6>>inputparam.bat
echo set IlwDir=%7>>inputparam.bat
echo set UtilDir=%8>>inputparam.bat
echo set DOY=%full_doy%%shortfilename2%>>inputparam.bat


copy "%UtilDir%\pattern.txt" >NUL
copy "%IlwDir%\Extensions\Geonetcast-Toolbox\toolbox_batchroutines\GEO_GOES16_GLM_loop.bat" >NUL


for %%j in (OR_GLM-L2-LCFA_G16_*.nc) do cmd /c GEO_GOES16_GLM_loop.bat %%j 

cmd /c copy glm*_3.txt glm_all.txt >NUL
echo.
echo Create point map
"%IlwDir%\ILWIS.exe" -C '%OutputDrive%\%OutputDir%\GOES16_GML_%longfilename%'.tbt:=table('%OutputDrive%\%OutputDir%\glm_all'.txt,Comma,Convert,none,ID(string),Y(value.dom{-90.99474:90.44161:0}),X(value.dom{-135.7072:-10.67214:1e-005}),energy(value.dom{0:10000:1}) -import
"%IlwDir%\ILWIS.exe" -C '%OutputDrive%\%OutputDir%\GOES16_GML_%longfilename%'.mpp:=PointMapFromTable('%OutputDrive%\%OutputDir%\GOES16_GML_%longfilename%',LATLON,pnt)


del out*.txt
del "%OutputDrive%\%OutputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tgz"
del "%OutputDrive%\%OutputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2%*.tar"
del "%OutputDrive%\%OutputDir%\OR_GLM-L2-LCFA_G16_s%full_doy%%shortfilename2:~0,-1%*.nc"
del "%OutputDrive%\%OutputDir%\glm*.txt"
del "%OutputDrive%\%OutputDir%\pattern.txt"
del "%OutputDrive%\%OutputDir%\inputparam.bat"
del "%OutputDrive%\%OutputDir%\GEO_GOES16_GLM_loop.bat"

:END
"%IlwDir%\ilwis.exe" -C closeall