@echo off
echo rem: Import of Fenyung-2G, 5 km resolution satellite situated at 104.5 degree East
echo 5 channels, (T)IR and VIS 


set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
cd\
%OutputDrive%
cd %OutputDir%



echo *%OutputDrive%\%OutputDir%*


copy %InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_*.GZ %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_*.GZ" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_*.GZ" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z.exe" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_*.gz

"%gdalDir%\gdal_translate" -of ilwis -of ilwis hdf5:"Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_IR1_001_NOM.hdf"://NOMChannelIR1 "%OutputDrive%\%OutputDir%\tfy2Gir1%shortfilename1%"
"%gdalDir%\gdal_translate" -of ilwis -of ilwis hdf5:"Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_IR2_001_NOM.hdf"://NOMChannelIR2 "%OutputDrive%\%OutputDir%\tfy2Gir2%shortfilename1%"
"%gdalDir%\gdal_translate" -of ilwis -of ilwis hdf5:"Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_IR3_001_NOM.hdf"://NOMChannelIR3 "%OutputDrive%\%OutputDir%\tfy2Gir3%shortfilename1%"
"%gdalDir%\gdal_translate" -of ilwis -of ilwis hdf5:"Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_IR4_001_NOM.hdf"://NOMChannelIR4 "%OutputDrive%\%OutputDir%\tfy2Gir4%shortfilename1%"
"%gdalDir%\gdal_translate" -of ilwis -of ilwis hdf5:"Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_VIS_001_NOM.hdf"://NOMChannelVIS "%OutputDrive%\%OutputDir%\tfy2Gvis%shortfilename1%"



"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tfy2Gir1%shortfilename1%.mpr %UtilDir%\fy2Glow_final;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tfy2Gir2%shortfilename1%.mpr %UtilDir%\fy2Glow_final;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tfy2Gir3%shortfilename1%.mpr %UtilDir%\fy2Glow_final;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tfy2Gir4%shortfilename1%.mpr %UtilDir%\fy2Glow_final;
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\tfy2Gvis%shortfilename1%.mpr %UtilDir%\fy2Glow_final;


"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FY2Gir1_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tfy2Gir1%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\tfy2Gir1%shortfilename1%,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FY2Gir2_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tfy2Gir2%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\tfy2Gir2%shortfilename1%,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FY2Gir3_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tfy2Gir3%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\tfy2Gir3%shortfilename1%,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FY2Gir4_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tfy2Gir4%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\tfy2Gir4%shortfilename1%,?)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\FY2Gvis_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tfy2Gvis%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\tfy2Gvis%shortfilename1%,?)



del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_FDI_*.HDF.gz
del *.hdf
del *.xml

del tfy2Gir*.*
del tfy2Gvis*.*



:END
"%IlwDir%\ilwis.exe" -C closeall